var gSnake = {
  startSpeed: 1000,
  speedInc: 0.9,
  intSpeedInc: 0.9,
  intSpeedIncTime: 7000,
  fieldX: 20,
  fieldY: 20,
  obs: true,
  obj: $('#gSnake')
};

gSnake.fTime = gSnake.startSpeed;

/*-------------------------------------------------------------------*/
//     

gSnake.set = function(obj){
  if(obj.startSpeed)
    gSnake.startSpeed = obj.startSpeed * 1;
  if(obj.speedInc)
    gSnake.speedInc = obj.speedInc * 1;
  if(obj.intSpeedInc)
    gSnake.intSpeedInc = obj.intSpeedInc * 1;
  if(obj.intSpeedIncTime)
    gSnake.intSpeedIncTime = obj.intSpeedIncTime * 1;
  gSnake.fieldX = obj.fieldX * 1; if(gSnake.fieldX < 10) gSnake.fieldX = 10;
  gSnake.fieldY = obj.fieldY * 1; if(gSnake.fieldY < 10) gSnake.fieldY = 10;
  gSnake.obs = false; if(obj.obs) gSnake.obs = true;
}

/*-------------------------------------------------------------------*/
//   

gSnake.generate = function(){
  gSnake.obj.html('<table id="gField" border="0"></table>');
  gSnake.field = gSnake.obj.find('#gField');
  for(var i = 0; i < gSnake.fieldY; i++)
  {
    $('<tr></tr>').attr('y', i).appendTo(gSnake.field);
    for(var j = 0; j < gSnake.fieldX; j++)
    {
        $('<td></td>').attr('x', j).appendTo(gSnake.field.find('tr[y=' + i + ']'));
    }
  }

  gSnake.field.find('tr[y=' + Math.floor(gSnake.fieldY / 2) + ']').find('td[x=0]').addClass('gsection end').parent().find('td[x=1]').addClass('gsection start');

  gSnake.obj.data('play', 0);
  gSnake.showButton();

  if($('body').data('highScore'))
    $('<div id="gHighScore"></div>').appendTo(gSnake.obj).html(' : <span></span>').find('span').text($('body').data('highScore'));

  if(gSnake.obs)
    gSnake.generateObs();

  $('<div id="gSettings"></div>').appendTo(gSnake.obj).html(
    '<div class="gSetCaption"></div>' +
    '<div class="gSetForm">' +
    '<form action="" method="POST">' +
    '<label>  :<br/><input type="text" name="fieldX" value="' + gSnake.fieldX + '"/></label><br/>' +
    '<label>  :<br/><input type="text" name="fieldY" value="' + gSnake.fieldY + '"/></label><br/>' +
    '<label><input type="checkbox" name="obs" value="1"' + (gSnake.obs ? 'checked="checked"' : '') + '/> </label><br/>' +
    '<input type="submit" name="save" value=""/>' +
    '</form>' +
    '</div>'
  );
}

/*-------------------------------------------------------------------*/
//   

gSnake.showSetPanel = function(){
  $('#gSettings').addClass('opened');
  $('#gSettings > div.gSetForm').fadeIn(500);
}

$('#gSettings > div.gSetCaption').live('click', function(){ gSnake.showSetPanel(); });

/*-------------------------------------------------------------------*/
//   

gSnake.hideSetPanel = function(){
  $('#gSettings').removeClass('opened');
  $('#gSettings > div.gSetForm').fadeOut(200)
}

$('#gSettings.opened > div.gSetCaption').live('click', function(){ gSnake.hideSetPanel(); });

/*-------------------------------------------------------------------*/
//  

$('#gSettings > div.gSetForm form').live('submit', function(){
  obj = {};
  obj.fieldX = parseInt($(this).find('input[name=fieldX]').val());
  $(this).find('input[name=fieldX]').val(parseInt($(this).find('input[name=fieldX]').val()));
  obj.fieldY = parseInt($(this).find('input[name=fieldY]').val());
  $(this).find('input[name=fieldY]').val(parseInt($(this).find('input[name=fieldY]').val()));
  obj.obs = ($(this).find('input[name=obs]:checked').length ? true : false);
  gSnake.set(obj);
  gSnake.restart();
  return false;
});

/*-------------------------------------------------------------------*/
//  

gSnake.generateSingleObstacle = function(){
  d = new Date();
  x = Math.round(Math.random() * (gSnake.fieldX));
  y = Math.round(Math.random() * (gSnake.fieldY));

  e = gSnake.obj.find('tr[y=' + y + '] td[x=' + x + ']');
  if(e.hasClass('gsection') || e.hasClass('obstacle'))
    gSnake.generateSingleObstacle();
  else
    e.addClass('obstacle');
}

gSnake.generateObs = function(){
  d = new Date();
  total = Math.round(Math.random() * (gSnake.fieldX * gSnake.fieldY * 0.07))
  if(total < 5) total = 5;

  for(var i = 1; i <= total; i++)
  { gSnake.generateSingleObstacle(); }
}

/*-------------------------------------------------------------------*/
// /  

gSnake.showButton = function(){
  if(!gSnake.obj.find('a.g-button').length)
    $('<a></a>').addClass('g-button').html(' ').appendTo(gSnake.obj);

  gSnake.obj.find('a.g-button').css('left', (gSnake.obj.width() + 7) + 'px').fadeIn(400);
}

/*-------------------------------------------------------------------*/
//  

gSnake.start = function(){
  gSnake.obj.find('a.g-button').html('!');
  $('<a></a>').addClass('g-indicator').html(' : <span id="g-score">2</span>').css({
    left: (gSnake.obj.width() + 7) + 'px',
    top: (gSnake.obj.height() - 40) + 'px',
    display: 'none'
  }).appendTo(gSnake.obj).fadeIn(400);

  gSnake.obj.data('play', 1).attr('length', 2).data('failed', 0);
  gSnake.fTime = gSnake.startSpeed;
  gSnake.intIncTimer = setTimeout('gSnake.intervalInc()', gSnake.intSpeedIncTime);
  gSnake.setEat();
  gSnake.main();
};

/*-------------------------------------------------------------------*/
//  

gSnake.finish = function(){
  gSnake.obj.find('td.gsection').addClass('red');
  gSnake.obj.find('a.g-button').html(' !');
  gSnake.obj.find('a.g-indicator').html(' !');
  gSnake.obj.data('failed', 1);
  if(parseInt($('body').data('highScore')) < gSnake.obj.find('td.gsection').length || !$('body').data('highScore'))
  {
    $('body').data('highScore', gSnake.obj.find('td.gsection').length);
    $('#gHighScore span').html(gSnake.obj.find('td.gsection').length);
  }

  clearTimeout(gSnake.intIncTimer);
  clearTimeout(gSnake.mainTimer);
}

/*-------------------------------------------------------------------*/
//  

gSnake.restart = function(){
  gSnake.obj.html();
  gSnake.generate();

  clearTimeout(gSnake.intIncTimer);
  clearTimeout(gSnake.mainTimer);
};

gSnake.obj.find('a.g-button').live('click', function(){
  if(gSnake.obj.data('play'))
    gSnake.restart();
  else
    gSnake.start();
});

/*-------------------------------------------------------------------*/
//  

gSnake.setEat = function(){
  d = new Date();
  gSnake.obj.find('td.eat').removeClass('eat');
  x = Math.round(Math.random() * (gSnake.fieldX - 1));
  y = Math.round(Math.random() * (gSnake.fieldY - 1));
  e = gSnake.obj.find('tr[y=' + y + '] td[x=' + x + ']');
  if(e.hasClass('gsection') || e.hasClass('obstacle') || y > gSnake.fieldY || y < 0 || x > gSnake.fieldX || x < 0)
    gSnake.setEat();
  else
    e.addClass('eat');
}

/*-------------------------------------------------------------------*/
//  

gSnake.move = function(){
  //  
  t = gSnake.obj.find('td.start');
  direction = t.data('direction') || 'r';

  x = t.attr('x');
  y = t.parent().attr('y');

  switch(direction)
  {
    case 'r': ++x; break;
    case 'l': --x; break;
    case 't': ++y; break;
    case 'b': --y; break;
  }

  addSection = false;
  newField = gSnake.obj.find('tr[y=' + y + '] td[x=' + x + ']');
  if(newField.hasClass('eat'))
  {
    gSnake.setEat();
    gSnake.obj.attr('length', parseInt(gSnake.obj.attr('length')) + 1);
    $('#g-score').html(parseInt($('#g-score').html()) + 1);
    addSection = true;
    gSnake.incSpeed(gSnake.speedInc);
  }
  else if(newField.hasClass('gsection') || newField.hasClass('obstacle') || x >= gSnake.fieldX || x < 0 || y >= gSnake.fieldY || y < 0)
  {
    gSnake.finish();
    return false;
  }

  t.removeClass('start directed');
  newField.addClass('gsection start').data('direction', direction)

  if(addSection)
    return true;

  //  
  t = gSnake.obj.find('td.end');
  direction = t.data('direction') || 'r';
  x = t.attr('x');
  y = t.parent().attr('y');

  switch(direction)
  {
    case 'r': ++x; break;
    case 'l': --x; break;
    case 't': ++y; break;
    case 'b': --y; break;
  }

  t.removeClass('end gsection');
  gSnake.obj.find('tr[y=' + y + '] td[x=' + x + ']').addClass('end');
}

/*-------------------------------------------------------------------*/
//    

$(function(){
  gSnake.generate();
});

/*-------------------------------------------------------------------*/
//   

gSnake.setDirection = function(direction){
  gSnake.obj.find('td.start').data('direction', direction).addClass('directed');
}

$('body').keydown(function(e){
  switch(e.keyCode)
  {
    case 39: direction = 'r'; break;
    case 37: direction = 'l'; break;
    case 38: direction = 'b'; break;
    case 40: direction = 't'; break;
  }

  current = gSnake.obj.find('td.start').data('direction');
  if((current == 'l' && direction == 'r') || (current == 'r' && direction == 'l') || (current == 't' && direction == 'b') || (current == 'b' && direction == 't') || current == direction)
    direction = false

  if(direction)
  {
    if(!gSnake.obj.find('td.start').hasClass('directed'))
        gSnake.setDirection(direction);
  }

  return true;
});

/*-------------------------------------------------------------------*/
//   

gSnake.incSpeed = function(coef){ gSnake.fTime *= coef; }
gSnake.intervalInc = function(){
  gSnake.incSpeed(gSnake.intSpeedInc);
  gSnake.intIncTimer = setTimeout('gSnake.intervalInc()', gSnake.intSpeedIncTime);
}

/*-------------------------------------------------------------------*/
//  

gSnake.main = function(){
  if(gSnake.obj.data('failed'))
    return false;

  gSnake.move();
  gSnake.mainTimer = setTimeout('gSnake.main()', gSnake.fTime);
}