<?php
/*
 * @Author: Papezhuk M. V.
 * @Site:   http://nurd-cms.ru
 * @NAME:	UNIChat 2.0
 */

/*	CMS Start	BEGIN	*/
define('_IN_JOHNCMS', 1);
require('../incfiles/core.php');
$textl = 'UNIChat';
$headmod = 'unichat';
require('../incfiles/head.php');
/*	CMS Start	END	*/


/*	LOAD API CLASS AND CACHE	BEGIN	*/
require('API.Class.php');
require('cache.Class.php');
/*	LOAD API CLASS AND CACHE END	*/


/*	Load ini BEGIN	*/
$_SETTINGS = array();
if (file_exists('config.ini'))
	$_SETTINGS = parse_ini_file('config.ini');
/*	Load ini END	*/


/*	UNICHAT	Func	BEGIN	*/

// Отправка запроса и получение ответа от сервера
function getRequest ($query = null)
{
	global $_SETTINGS;
	$reqTo = $_SETTINGS['SERVER'] . $query;
	return json_decode(file_get_contents($reqTo), true);
}

// Получение и кеширование онлайна
function getOnline($newCache = false)
{
	$reCache = 0;
	if (file_exists('cache/dump_online.ini') && $newCache === false)
	{
		$reCache = intval(file_get_contents('cache/dump_online.ini'));

		$request = array();
		if ($reCache > time())
			include 'cache/dump_online.php';
		else
		{
			$request = getRequest('update.php');
			file_put_contents('cache/dump_online.php', "<?php\nunset(\$request);\n\$request = ". var_export($request, true) .";\n?>");
			file_put_contents('cache/dump_online.ini', time()+300);
		}
	}
	else
	{
		$request = getRequest('update.php');
		file_put_contents('cache/dump_online.php', "<?php\nunset(\$request);\n\$request = ". var_export($request, true) .";\n?>");
		file_put_contents('cache/dump_online.ini', time()+300);
	}
	return $request;
}

// Получение ника пользователя
function getNick() {
	global $login;
	return $login;
}


// Код ошибки
function errCode($error_code = '100') {
	switch ($error_code) {
		default:
			return null;
		break;

		case '404':
			return 'Запрещено писать с локальных серверов типа Denwer';
		break;

		case '503':
			return 'Слишком короткое сообщение';
		break;

		case '504':
			return 'Нельзя писать одинаковые сообщения чаще 1 раза в минуту';
		break;
	}
}
/*	UNICHAT	Func	END	*/
?>