# coding: utf8
from django.contrib import admin
from django.contrib.auth.models import User
from base.models import Topic, Comment
from django_markdown.admin import MarkdownModelAdmin

class TopicAdmin(MarkdownModelAdmin):
    list_display = ("author", "title") # поля, показывающие при выводе списка 
    search_fields = ("author", "title",) # поля, по которым ведеться поиск
    readonly_fields = ('date',) # поля, которые нельзя изменять
    exclude = ('text',) # поля, тоторые не надо показывать   
    list_filter = ("author",) # поля для фильтров

class CommentAdmin(MarkdownModelAdmin):
    list_display = ("author", "topic",)
    search_fields = ("author", "topic.title",)
    readonly_fields = ('topic', 'date',)
    exclude = ('text',)    
    list_filter = ("author",)

admin.site.register(Topic, TopicAdmin)
admin.site.register(Comment, CommentAdmin)
admin.site.unregister(User)
