# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding model 'Topic'
        db.create_table('base_topic', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('author', self.gf('django.db.models.fields.CharField')(max_length=50)),
            ('title', self.gf('django.db.models.fields.CharField')(max_length=120)),
            ('text', self.gf('django.db.models.fields.TextField')()),
            ('text_markdown', self.gf('django.db.models.fields.TextField')(default='hb')),
            ('date', self.gf('django.db.models.fields.DateTimeField')(auto_now_add=True, blank=True)),
        ))
        db.send_create_signal('base', ['Topic'])

        # Adding model 'Comment'
        db.create_table('base_comment', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('topic', self.gf('django.db.models.fields.related.ForeignKey')(related_name='comments', to=orm['base.Topic'])),
            ('author', self.gf('django.db.models.fields.CharField')(max_length=50)),
            ('text', self.gf('django.db.models.fields.TextField')()),
            ('text_markdown', self.gf('django.db.models.fields.TextField')(default='hb')),
            ('date', self.gf('django.db.models.fields.DateTimeField')(auto_now_add=True, blank=True)),
            ('parent', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='children', null=True, to=orm['base.Comment'])),
        ))
        db.send_create_signal('base', ['Comment'])


    def backwards(self, orm):
        # Deleting model 'Topic'
        db.delete_table('base_topic')

        # Deleting model 'Comment'
        db.delete_table('base_comment')


    models = {
        'base.comment': {
            'Meta': {'ordering': "('date',)", 'object_name': 'Comment'},
            'author': ('django.db.models.fields.CharField', [], {'max_length': '50'}),
            'date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'parent': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'children'", 'null': 'True', 'to': "orm['base.Comment']"}),
            'text': ('django.db.models.fields.TextField', [], {}),
            'text_markdown': ('django.db.models.fields.TextField', [], {'default': "'hb'"}),
            'topic': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'comments'", 'to': "orm['base.Topic']"})
        },
        'base.topic': {
            'Meta': {'ordering': "('-date',)", 'object_name': 'Topic'},
            'author': ('django.db.models.fields.CharField', [], {'max_length': '50'}),
            'date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'text': ('django.db.models.fields.TextField', [], {}),
            'text_markdown': ('django.db.models.fields.TextField', [], {'default': "'hb'"}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '120'})
        }
    }

    complete_apps = ['base']