# coding: utf8
from django.db import models


class Topic(models.Model):
    # Топик
    author = models.CharField(u"Автор", max_length = 50)
    title = models.CharField(u"Тема", max_length = 120)
    text = models.TextField(u"Текст")
    text_markdown = models.TextField(u"Текст с markdown")
    date = models.DateTimeField(u"Дата создания", auto_now_add = True)

    def save(self, *args, **kwargs):
        # пепеоприделяем метод сохрениния модели
        # при сохренении производим преобразование текста с markdown
        import markdown
        self.text = markdown.markdown(self.text_markdown)
        super(Topic, self).save(*args, **kwargs) 
    
    def __unicode__(self):
        return u"%s | %s" %(self.author, self.title) 

    class Meta:
        verbose_name = u"Топик"
        verbose_name_plural = u"Топики" 
        ordering = ("-date",)



class Comment(models.Model):
    # коментарий к топику
    topic = models.ForeignKey("Topic", related_name = "comments", verbose_name = u"топик")
    author = models.CharField(u"Автор", max_length = 50)
    text = models.TextField(u"Текст")
    text_markdown = models.TextField(u"Текст с markdown")
    date = models.DateTimeField(u"Дата создания", auto_now_add = True)
    parent = models.ForeignKey("self", related_name = "children", verbose_name = u"родитель", null = True, blank = True)
    
    def save(self, *args, **kwargs):
        # пепеоприделяем метод сохрениния модели
        # при сохренении производим преобразование текста с markdown
        import markdown
        self.text = markdown.markdown(self.text_markdown)
        super(Comment, self).save(*args, **kwargs) 
 
    def __unicode__(self):
        return u"%s |%s ... " %(self.topic.title, self.author) 

    class Meta:
        verbose_name = u"Коментарий"
        verbose_name_plural = u"Коментарии" 
        ordering = ("date",)

    