# coding: utf8
from django.views.generic import View, TemplateView, FormView, ListView, DetailView
from django.shortcuts import redirect
from django.http import Http404
from base.models import Topic, Comment
from base.forms import CommentForm 


class IndexView(ListView):
    # Класс главной страницы.
    # Постраничный вывод Топиков
    # Стандартно выводяться все топики, сортировка определена в models.py
    template_name = "index.html" # имя шаблона
    model = Topic # Класс модели которую выводим постранично
    paginate_by = 5 # Количество топиков на страницу
        

class TopicView(FormView):
    # Класс вывода топика с коментарьями и форрмоц отправки коментариев
    template_name = "topic.html"
    model = Topic
    form_class = CommentForm # Класс формы для отправки коментариев
        
    def dispatch(self, request, *args, **kwargs):
        # проверчем, есть ли топик с таким айди как в url
        # если нет, то выдаем 404 ошибку
        try:
            self.topic = Topic.objects.get(id = kwargs.get("pk"))
        except Topic.DoesNotExist, ValueError:
            raise Http404
        return super(TopicView, self).dispatch(request, *args, **kwargs)

    def get_context_data(self, **kwargs):
        context = super(TopicView, self).get_context_data(**kwargs)
        # добавляем в контекст топик, и коментарии без родителя
        context["object"] = self.topic
        context["comments"] = self.topic.comments.filter(parent = None)
        return context 

    # если форма прошла проверку
    def form_valid(self, form):
        cd = form.cleaned_data # хэш с данными формы 
        topic = self.topic # топик, к которому пишеться комментарий
        parent = None # мы коментируем топик, а не коментарий
        if self.request.GET.get("comment"): # если в гет есть id коментария, который мы хочем коментировать
            try: parent = Comment.objects.get(topic = self.topic, id = self.request.GET.get("comment"))  # сущиствует ли этот коментарий, и принадлежит ли к этому топику
            except Comment.DoesNotExist, ValueError: pass
        # создаем коментарий
        comment = Comment.objects.create(
            topic = topic,
            author = cd["author"],
            text_markdown = cd["text"],
            parent = parent
        ) 
        return redirect("/topic/%i/#comment%i" % (topic.id, comment.id)) # переадрисация на страницу топика       

