<!--  start of middle content area -->
<div id="ieCenter"><div id="content"><div class="forumline">
<div class="forumline" style="background-color:#eaedf4; margin: 1px 1px 0px 1px; padding:5px;">

Once you have your table data organized, the next step is to figure out the data type. There are three main types : <strong>text, numbers, </strong>and <strong>Dates/Times</strong>. Choosing the column types specifies what information can or can't be stored in a table cell. Using the most correct option for each column is important as it may affect the database's overall performance.
<br /><br />

<strong>TEXT TYPES</strong>
<table style="width:100%;border:#c0c0c0 solid 1px;"><tr>
<td style="width:125px;">CHAR( )</td><td>A fixed section from 0 to 255 characters long.</td>
</tr><tr>
<td>VARCHAR( )</td><td>A variable section from 0 to 255 characters long.</td>
</tr><tr>
<td>TINYTEXT</td><td>A string with a maximum length of 255 characters.</td>
</tr><tr>
<td>TEXT</td><td>A string with a maximum length of 65535 characters.</td>
</tr><tr>
<td>BLOB</td><td>A string with a maximum length of 65535 characters.</td>
</tr><tr>
<td>MEDIUMTEXT</td><td>A string with a maximum length of 16777215 characters.</td>
</tr><tr>
<td>MEDIUMBLOB</td><td>A string with a maximum length of 16777215 characters.</td>
</tr><tr>
<td>LONGTEXT</td><td>A string with a maximum length of 4294967295 characters.</td>
</tr><tr>
<td>LONGBLOB</td><td>A string with a maximum length of 4294967295 characters.</td>
</tr></table>

<br />
The ( ) brackets allow you to enter a maximum number of characters will be used in the column.
<div class="clsEX">
VARCHAR(20)
</div>
<br />
CHAR and VARCHAR are the most widely used types. CHAR is a fixed length string and is mainly used when the data is not going to vary much in it's length. VARCHAR is a variable length string and is mainly used when the data may vary in length.
<br /><br />
CHAR may be faster for the database to process considering the fields stay the same length down the column. VARCHAR may be a bit slower as it calculates each field down the column, but it saves on memory space. Which one to ultimatly use is up to you.
<br /><br />
Using both a CHAR and VARCHAR option in the same table, MySQL will automatically change the CHAR into VARCHAR for compatability reasons.
<br /><br />
BLOB stands for Binary Large OBject. Both TEXT and BLOB are variable length types that store large amounts of data. They are similar to a larger version of VARCHAR. These types can store a large piece of data information, but they are also processed much slower.
<br /><br />

<strong>NUMBER TYPES</strong>
<table style="width:100%;border:#c0c0c0 solid 1px;"><tr>
<td style="width:125px;">TINYINT( )</td><td>-128 to 127 normal<br />0 to 255 UNSIGNED.</td>
</tr><tr>
<td>SMALLINT( )</td><td>-32768 to 32767 normal<br />0 to 65535 UNSIGNED.</td>
</tr><tr>
<td>MEDIUMINT( )</td><td>-8388608 to 8388607 normal<br />0 to 16777215 UNSIGNED.</td>
</tr><tr>
<td>INT( )</td><td>-2147483648 to 2147483647 normal<br />0 to 4294967295 UNSIGNED.</td>
</tr><tr> 
<td>BIGINT( )</td><td>-9223372036854775808 to 9223372036854775807 normal<br />0 to 18446744073709551615 UNSIGNED.</td>
</tr><tr>
<td>FLOAT</td><td>A small number with a floating decimal point.</td>
</tr><tr>
<td>DOUBLE( , )</td><td>A large number with a floating decimal point.</td>
</tr><tr>
<td>DECIMAL( , )</td><td>A DOUBLE stored as a string , allowing for a fixed decimal point.</td>
</tr></table>

<br />
The integer types have an extra option called <span style="color:#ff0000;">UNSIGNED</span>. Normally, the integer goes from an negative to positive value. Using an UNSIGNED command will move that range up so it starts at zero instead of a negative number.
<br /><br />

<strong>DATE TYPES</strong>
<table style="width:100%;border:#c0c0c0 solid 1px;"><tr>
<td style="width:125px;">DATE</td><td>YYYY-MM-DD.</td>
</tr><tr> 
<td>DATETIME</td><td>YYYY-MM-DD HH:MM:SS.</td>
</tr><tr> 
<td>TIMESTAMP</td><td>YYYYMMDDHHMMSS.</td>
</tr><tr> 
<td>TIME</td><td>HH:MM:SS.</td>
</tr></table>

<br />

<strong>MISC TYPES</strong>
<table style="width:100%;border:#c0c0c0 solid 1px;"><tr>
<td style="width:125px;">ENUM ( )</td><td>Short for ENUMERATION which means that each column may have one of a specified possible values.</td>
</tr><tr> 
<td>SET</td><td>Similar to ENUM except each column may have more than one of the specified possible values.</td>
</tr></table>

<br />
ENUM is short for ENUMERATED list. This column can only store one of the values that are declared in the specified list contained in the ( ) brackets.
<br />
<div class="clsEX">
ENUM('y','n')
</div>
You can list up to 65535 values in an ENUM list. If a value is inserted that is not in the list, a blank value will be inserted.
<br /><br />
SET is similar to ENUM except SET may contain up to 64 list items and can store more than one choice.

</div>

</div>

</div></div>
<!-- end of middle content area -->