<?php

/**
 * Библиотека для johncms 4.4.0
 *
 * Настройки модуля
 *
 * @author Screamer <nwotnbm@gmail.com>
 * @version 1.0
 * @copyright 2012
 */

defined('_IN_JOHNCMS') or die('Restricted access');

if (core::$user_rights >= 7)
{

    echo '<div class="phdr"><a href="index.php">' . lng('library') . '</a> | <a href="?act=panel&amp;mod=view">' . lng('control_panel') . '</a></div>';

    if (!empty($_POST))
    {

        if (isset($_POST['default']))
        {

            $settings = array(
                'main_deal' => 10, // Кол-во статей на стартовой странице (Не более 10)
                'zip_deal' => 10, // Кол-во файлов в zip архиве
                'mod_close' => 0,
                'files' => array(
                    'extensions' => array(
                        'png', 'jpg', 'bmp', 'gif',
                        'zip', 'rar', '7z', 'jar', 'tar',
                        'mp3', 'amr', 'aac', 'm4a', 'wav',
                        'mp4', 'avi', '3gp',
                        'exe', 'bin',
                        'txt', 'conf', 'log'
                    ),
                    /* Максимальное кол-во файлов для статьи */
                    'max_number' => 10
                ),
                'tags_max_cache_time' => 86400

            );

        }
        else
        {

            $err = array();
            $settings = array();

            /* Проверка параметров */

            /* Контроль доступа */
            $settings['mod_close'] = !empty($_POST['mod_close']) ? abs(intval($_POST['mod_close'])) : 0;
            if ($settings['mod_close'] < 0 || $settings['mod_close'] > 2)
                $err[] = lng('sett_mod_close_err');

            /* Кол-во статей на главной */
            $settings['main_deal'] = !empty($_POST['main_deal']) ? abs(intval($_POST['main_deal'])) : 0;
            if ($settings['main_deal'] < 2 || $settings['main_deal'] > 10)
                $err[] = lng('sett_main_deal_err');

            /* Кол-во файлов в zip */
            $settings['zip_deal'] = !empty($_POST['zip_deal']) ? abs(intval($_POST['zip_deal'])) : 0;
            if ($settings['zip_deal'] < 1 || $settings['zip_deal'] > 40)
                $err[] = lng('sett_zip_deal_err');

            /* Расширения файлов */
            if (!empty($_POST['files']['extensions']))
            {

                $settings['files']['extensions'] = $_POST['files']['extensions'];
                if (preg_match("/[^\da-z,]+/", $settings['files']['extensions']))
                    $err[] = lng('sett_files_exts_symbols');
                else
                    $settings['files']['extensions'] = explode(',', $settings['files']['extensions']);

            }
            else
                $err[] = lng('sett_files_exts_empty');

            /* Кол-во файлов для статьи */
            $settings['files']['max_number'] = !empty($_POST['files']['max_number']) ? abs(intval($_POST['files']['max_number'])) : 0;
            if ($settings['files']['max_number'] > 40)
                $err[] = lng('sett_files_number_err');

            /* Время хранения кэша списка тегов */
            $settings['tags_max_cache_time'] = !empty($_POST['tags_max_cache_time']) ? abs(intval($_POST['tags_max_cache_time'])) : 0;
            if ($settings['tags_max_cache_time'] < 1 || $settings['tags_max_cache_time']  > 100)
                $err[] = lng('sett_tags_max_cache_time_err');
            $settings['tags_max_cache_time'] = $settings['tags_max_cache_time'] * 3600;

        }

        if (empty($err))
        {

            mysql_query("UPDATE `mod_lib_set` SET `val` = '" . serialize($settings) . "' WHERE `key` = 'set'");
            $message = lng('settings_saved');

        }
        else
        {

            $message = implode('<br />', $err);

        }

        echo '<div class="menu"><h3>' . lng('settings') . '</h3>' . $message .
             '<br /><a href="?act=panel&amp;mod=settings">' . lng('continue') . '</a> | <a href="index.php">' . lng('to_library') . '</a></div>';

    }
    else
    {

        echo '<form action="?act=panel&amp;mod=settings" method="post">' .
             '<div class="menu"><h3>' . lng('settings') .
             '</h3><p><input type="text" maxlength="2" name="main_deal" value="' . intval($libSet['main_deal']) . '" size="2" />&#160;' .
             lng('arcs_deal_mainpage') . ' (2-10)</p>' .
             '<p><input type="text" maxlength="2" name="zip_deal" value="' . intval($libSet['zip_deal']) . '" size="2" />&#160;' .
             lng('arcs_deal_zip') .' (1-40)</p><p>' .
             lng('arcs_files_extensions') . ':<br />' .
             '<textarea rows="6" name="files[extensions]">' . implode(',', $libSet['files']['extensions']) . '</textarea></p>' .
             '<p><input type="text" maxlength="2" name="files[max_number]" value="' . intval($libSet['files']['max_number']) . '" size="2" />&#160;' .
             lng('arcs_files_number') . ' (0-40, 0 - ' . lng('arcs_files_number_1') . ')' .
             '</p><p><input type="text" maxlength="3" name="tags_max_cache_time" value="' . (intval($libSet['tags_max_cache_time']) / 3600) . '" size="2" />&#160;' .
             lng('tags_max_cache_time') . ' (1-100)</p>' .
             '<p>' . lng('access_control') . ':<br />' .
             '<input type="radio" name="mod_close" value="0"' . ($libSet['mod_close'] == 0 ? ' checked="checked"' : '') .
             ' />&#160;' . lng('open_for_all') . '<br />' .
             '<input type="radio" name="mod_close" value="1"' . ($libSet['mod_close'] == 1 ? ' checked="checked"' : '') .
             ' />&#160;' . lng('authorized_only') . '<br />' .
             '<input type="radio" name="mod_close" value="2"' . ($libSet['mod_close'] == 2 ? ' checked="checked"' : '') .
             ' />&#160;' . lng('close_for_all') . '</p><p>' .
             '<input type="submit" name="submit" value="' . lng('save') . '" /> <input type="submit" name="default" value="' . lng('set_default') . '" /></p></div></form>';

    }

    echo '<div class="phdr"><a href="?act=panel&amp;mod=view">' . lng('back') . '</a></div>';

}
else
{

    $error = lng('access_denied');

}