<?php

/**
* Библиотека для johncms 4.4.0
*
* Точка входа в модуль. Переключение режима работы.
*
* @author Screamer <nwotnbm@gmail.com>
* @version 1.0
* @copyright 2012
*/
// error_reporting(-1);
define('_IN_JOHNCMS', 1);

/* Директорий подключаемых файлов */
define('INCDIR', dirname(__FILE__) . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR);
/* Директорий файлов */
define('FILESDIR', dirname(__FILE__) . DIRECTORY_SEPARATOR . 'files' . DIRECTORY_SEPARATOR);
/* Директорий системных файлов */
define('SYSDIR', realpath('../incfiles') . DIRECTORY_SEPARATOR);

require SYSDIR . 'core.php';

define('ICONSDIR', core::$system_set['homeurl'] . '/lib/files/icons/');
/* Загрузка основных функций */
require INCDIR . 'lib' . DIRECTORY_SEPARATOR . 'functions.php';
/* Загрузка языка */
core::$lng = array_merge(core::$lng, core::load_lng('lib'));
/* Настройки модуля */
$libSet = mysql_fetch_assoc(mysql_query("SELECT `val` FROM `mod_lib_set` WHERE `key` = 'set'"));
$libSet = unserialize($libSet['val']);

/* Закрытие доступа */
if (($libSet['mod_close'] == 1 && !core::$user_id) || ($libSet['mod_close'] == 2 && core::$user_rights < 7)) {
	$textl = lng('library');
	require SYSDIR . 'head.php';
	echo functions::display_error(lng('access_denied'));
	require SYSDIR . 'end.php';
	exit;
}

/* Список допустимых режимов работы и заголовков страниц для них */
$modes = array(
	/* Статьи */
	'articles'       => array(
		'attach'     => lng('attach') . '&#160;' . lng('file'),
		'download'   => lng('arc_download'),
		'edit'       => lng('arc_edit'),
		'form'       => ($do == 'add' ? lng('arc_add') : lng('arc_edit')),
		'save'       => ($do == 'add' ? lng('arc_add') : lng('arc_edit')),
		'remove'     => lng('arc_remove'),
		'move'       => lng('arc_move'),
		'upload'     => lng('arc_upload'),
		'vote'       => lng('vote'),
		'view'       => ''
	),
	/* Закладки */
	'bookmarks'      => array(
		'add'        => lng('bm_add'),
		'clean'      => lng('bm_clean'),
		'remove'     => lng('bm_remove'),
		'view'       => lng('bm_view'),
	),
	/* Категории */
	'category'       => array(
		'add'        => lng('cat_add'),
		'edit'       => lng('cat_edit'),
		'remove'     => lng('cat_remove'),
		'move'       => lng('cat_move'),
		'view'       => ''
	),
	/* Комментарии */
	'comments'       => lng('comments'),
	/* Главная страница */
	'mainpage'       => array(
		'view'       => lng('library')
	),
	/* Панель управления */
	'panel'          => array(
		'garbage'    => lng('garbage_collector'),
		'view'       => lng('control_panel'),
		'moderation' => lng('arcs_on_mod'),
		'settings'   => lng('settings'),
		'movdel'     => (isset($_REQUEST['move']) ? lng('checked_move') : lng('checked_delete'))
	),
	/* Поиск */
	'search'         => array(
		'view'       => lng('search')
	)
);

/* Если идет обращение к директорию с файлами */
$folders = array('files');
$uri = explode('/', $_SERVER['REQUEST_URI']);

if (!in_array($uri[1], $folders)) {
	/* Устанавливаем режим по умолчанию */
	$act = !empty($act) ? $act : 'mainpage';
	$mod = !empty($mod) ? $mod : 'view';
	$loading = array_key_exists($act, $modes);
	if ($loading) {
		if (is_array($modes[$act])) {
			$loading = array_key_exists($mod, $modes[$act]);
		} else {
			$loading = is_string($modes[$act]);
		}
	}
	if ($loading) {
		if (is_string($modes[$act])) {
			$mode = INCDIR . $act . '.php';
			/* Устанавливаем заголовок страницы */
			$textl = $modes[$act];
		} else {
			$mode = INCDIR . $act . DIRECTORY_SEPARATOR . $mod . '.php';
			/* Устанавливаем заголовок страницы */
			$textl = $modes[$act][$mod];
		}
		if (file_exists($mode)) {
			if (!empty($textl)) {
				require SYSDIR . 'head.php';
			}
			require $mode;
			/* Показ ошибок */
			if (!empty($error)) {
				echo '<div class="phdr">' . lng('library') . '</div>'
				     . functions::display_error($error)
				     . '<div class="phdr"><a href="index.php">' . lng('back') . '</a></div>';
			}
			if (!empty($textl)) {
				require SYSDIR . 'end.php';
			}
		} else {
			$error = TRUE;
		}
	} else {
		$error = TRUE;
	}
	/* Если запрашиваемый режим не найден, перенаправляем на страницу ошибки */
	if (isset($error) && $error === TRUE) {
		header('Location: ' . core::$system_set['homeurl'] . '/?err');
		exit;
	}
}