if (/http:\/\/johncms.com(.+?)/.test(document.location.href)) {
	window.onload = function () {
		document.head.appendChild(panel_css_style()); // CSS style of panel
		document.body.appendChild(toggle_panel()); // Toggle panel button
		document.body.appendChild(panel()); // Panel
		replace_elements(); // Replace elements
		set_stylesheet(); // Set stylesheet
	}
}

/**
 * Create panel
 */
function panel()
{
	var panel = document.createElement('div');
	panel.id = 'user_js_panel';
	panel.style.display = 'none';
	// CSS Styles selector
	var styles_selector = document.createElement('div');
	styles_selector.id = 'styles_selector';
	styles_selector.innerHTML = '<strong>Выберите стиль:</strong><br />';
	var available_styles = css_storage();
	for (var i = 0; i < available_styles.length; i++) {
		var option = document.createElement('a');
		option.href = 'javascript:set_style(\'' + available_styles[i][0] + '\')';
		option.innerHTML = available_styles[i][0];
		option.id = 'style_item';
		styles_selector.appendChild(option);
	}
	var option = document.createElement('a');
	option.href = 'javascript:set_default_style()';
	option.innerHTML = 'По умолчанию';
	option.id = 'style_item';
	styles_selector.appendChild(option);
	panel.appendChild(styles_selector);
	// End of CSS styles selector
	return panel;
}

/**
 * Toggle button for panel
 */
function toggle_panel()
{
	var toggle_panel = document.createElement('a');
	toggle_panel.id = 'toggle_user_jspanel';
	toggle_panel.href = "javascript:userjs_spoiler('user_js_panel')";
	toggle_panel.innerHTML = '[+/-]';
	return toggle_panel;
}

/**
 * Spoiler
 */
function userjs_spoiler(element_id)
{
	var element = document.getElementById(element_id);
	element.style.display = element.style.display == 'none' ? '' : 'none';
}

/**
 * Remove some elements from page
 */
function replace_elements()
{
	// Remove logo and language selector
	var tables = document.getElementsByTagName('table');
	if (tables.length > 0) {
		document.body.removeChild(tables[0]);
	}
	var links = document.getElementsByTagName('a');
	for (var l = 0; l < links.length; l++) {
		if (/http:\/\/johncms.com\/go.php\?id=[\d]+/.test(links[l].href)) {
			links[l].parentNode.style.display = "none";
		}
	}
	var forms = document.getElementsByTagName('form');
	for (var i = 0; i < forms.length; i++) {
		if (/forum\/index.php\?act=say\&id=[\d]+/.test(forms[i].action)) {
			var container = forms[i].parentNode;
			var action = forms[i].action;
			var get_token = document.getElementsByTagName('input');
			var token = 0;
			for (var t = 0; t < get_token.length; t++) {
				if (get_token[t].type == "hidden" && get_token[t].name == "token") {
					token = get_token[t].value;
					break;
				}
			}
			container.removeChild(forms[i]);
			container.appendChild(message_form(action, token));
			break;
		}
	}
	if (/http:\/\/johncms.com\/forum(.+?)\?id=[\d]+/.test(document.location.href)) {
		var thumbs = document.getElementsByTagName('img');
		for (var im = 0; im < thumbs.length; im++) {
			if ((im_name = /thumbinal\.php\?file=(.*)/.exec(thumbs[im].src)) != null) {
				thumbs[im].id = im_name[1];
				thumbs[im].parentNode.innerHTML
					+= "<br /><a href=\"javascript:toggle_image('" + im_name[1] + "')\">[+/-]</a>"
					+ "&#160;<a target=\"_blank\" href=\"http://google.com/searchbyimage?image_url=http://johncms.com/files/forum/attach/" + im_name[1] + "\">[G]</a>";
			}
		}
	}
}

/**
 * Toggle image
 */
function toggle_image(image)
{
	var el = document.getElementById(image);
	el.src = /thumbinal\.php/.test(el.src) ? 'http://johncms.com/files/forum/attach/' + image : 'http://johncms.com/forum/thumbinal.php?file=' + image;
}

/**
 * Message form
 */
function message_form(action, token_value)
{
	// From
	var form = document.createElement('form');
	form.action = action;
	form.method = "post";
	// BB panel
	var panel_container = document.createElement('div');
	panel_container.className = "bb_panel";
	// Buttons
	var buttons = [
		["[b]", "[/b]", "b"],
		["[i]", "[/i]", "i"],
		["[u]", "[/u]", "u"],
		["[s]", "[/s]", "s"],
		["[url=http://]", "[/url]", "url"],
		["[big]", "[/big]", "big"],
		["[small]", "[/small]", "small"],
		["[c]", "[/c]", ">"],
		["[php]", "[/php]", "#"],
		["[*]", "[/*]", "*"],
		["[red]", "[/red]", "r"],
		["[green]", "[/green]", "g"],
		["[blue]", "[/blue]", "b"]
	];
	for (var b = 0; b < buttons.length; b++) {
		var b_item = document.createElement('a');
		b_item.className = "bb_button";
		b_item.href = "javascript:insert_tag('" + buttons[b][0] + "', '" + buttons[b][1] + "')";
		b_item.innerHTML = buttons[b][2];
		panel_container.appendChild(b_item);
	}
	form.appendChild(panel_container);
	// Textarea
	var textarea = document.createElement('textarea');
	textarea.style.width = "97%";
	textarea.style.height = "150px";
	textarea.name = "msg";
	textarea.id = "message_form";
	form.appendChild(textarea);
	// Token
	var token = document.createElement('input');
	token.type = "hidden";
	token.name = "token";
	token.value = token_value;
	form.appendChild(token);
	// Attach file
	var file = document.createElement('input');
	file.type = "checkbox";
	file.name = "addfiles";
	file.value = "1";
	form.appendChild(file);
	form.innerHTML += "&#160;Прикрепить файл<br />";
	// Submit
	var submit = document.createElement('input');
	submit.type = "submit";
	submit.name = 'submit';
	submit.value = "Отправить";
	form.appendChild(submit);
	// Preview
	var preview = document.createElement('input');
	preview.type = "submit";
	preview.value = "Предосмотр";
	form.appendChild(preview);
	return form;
}

/**
 * Insert BB code to field
 */
function insert_tag(tag_open, tag_close)
{
	var e_field = document.getElementById('message_form');
	if (tag_open == '[c]') {
		if (window.getSelection) {
			tag_open += window.getSelection().toString() + "\n";
		} else if (document.getSelection) {
			tag_open += document.getSelection() + "\n";
		} else if (document.selection) {
			tag_open += document.selection.createRange().text + "\n";
		}
	}
	if (e_field.selectionStart != undefined) {
		// Work with selected text
		e_field.focus();
        var string = e_field.value;
        var start_selection = e_field.selectionStart;
        var end_selection = e_field.selectionEnd - start_selection;
        e_field.value = string.substr(0, start_selection)
    	             + tag_open
    	             + string.substr(start_selection, end_selection)
    	             + tag_close
    	             + string.substr(start_selection + end_selection);
	} else {
		// Add tags to end of text
		e_field.value += tag_open+tag_close;
	}
}

/**
 * Remember CSS style, toggle panel.
 */
function set_style(name)
{
	userjs_spoiler('user_js_panel');
	set_cookie('user_style', name, 365);
	document.location.href = document.location.href;
}

/**
 * Set default CSS style for page, Reload page
 */
function set_default_style()
{
	set_cookie('user_style', '', -1);
	document.location.href = document.location.href;
}

/**
 * Set css style
 */
function set_stylesheet()
{
	name = get_cookie('user_style');
	if (name) {
		// Remove old style
		var get_style = document.getElementsByTagName('link');
		var style;
		for (var i = 0; i < get_style.length; i++) {
			if (get_style[i].rel == "stylesheet") {
				style = get_style[i];
				break;
			}
		}
		if (style) {
			document.head.removeChild(style);
		}
		// Set new style
		var styles = css_storage();
		for (var i = 0; i < styles.length; i++) {
			if (styles[i][0] == name) {
				if (style) {
					// Set new style
					var new_style = document.createElement('style');
					new_style.id = 'user_style';
					new_style.innerHTML = styles[i][1];
					document.head.appendChild(new_style);
				}
				break;
			}
		}
	}
}

/**
 * Get cookie
 */
function get_cookie(name)
{
	with(document.cookie)
	{
		var regexp = new RegExp('(^|;\\s+)' + name + '=(.*?)(;|$)');
		var hit = regexp.exec(document.cookie);
		if(hit && hit.length > 2) return unescape(hit[2]);
		else return '';
	}
}

/**
 * Set cookie
 */
function set_cookie(name, value, days)
{
	if(days)
	{
		var date=new Date();
		date.setTime(date.getTime() + days*24*60*60*1000);
		var expires = '; expires=' + date.toGMTString();

	}
	else expires = '';
	document.cookie = name + '=' + value + expires + '; path=/';
}

/**
 * CSS Style of panel
 */
function panel_css_style()
{
	var element = document.createElement('style');
	element.id = 'userpanel_css';
	element.innerHTML = '#user_js_panel {'
				+ 'position: fixed; '
				+ 'bottom: 32px; '
				+ 'right: 4px; '
				//+ 'width: 400px; '
				+ 'height: 100px; '
				+ 'background: whitesmoke; '
				+ 'color: black; '
				+ 'padding: 4px; '
				+ 'margin: 0px;'
				+ 'box-shadow: 0px 0px 4px #3f3f3f;'
		+ '}'
		+ '#toggle_user_jspanel {'
			   + 'padding: 4px; '
			   + 'margin: 0px 4px 6px 0px; '
			   + 'display: inline-block; '
			   + 'background: whitesmoke; '
			   + 'border: 0;'
			   + 'font-weight: normal; '
			   + 'text-decoration: none; '
			   + 'position: fixed; '
			   + 'right: 0; '
			   + 'bottom: 0;'
			   + 'box-shadow: 0px 0px 4px #3f3f3f; '
			   + 'color: black; '
		+ '}'
		+ '#styles_selector {'
			+ 'margin: 2px;'
			+ 'padding: 2px; '
		+ '}'
		+ '#style_item {'
			+ 'display: block;'
			+ 'font-weight: normal; '
			+ 'border: 0; '
			+ 'text-decoration: none; '
		 	+ 'color: #305090;'
		 	+ 'margin: 2px 0px;'
		+ '}';
	return element;
}

/**
 * Storage of CSS files
 */
function css_storage()
{
	var styles = [
		/* Blue by Selement */
		['Blue', 'body { background-color: #f1f1f1; color: #000000; font: 12px Tahoma, Arial, Verdana; max-width: 500px; margin: 2px auto;}a , a:visited{ color:#425872; text-decoration: none;} a:hover{color:#666;}h3 { margin: 0; padding: 0; padding-bottom: 2px;}hr { border: 0; border-top: 1px solid gray; margin: 0;} p { padding:  3px; color: #000336;} select { border-width: 2px 2px 2px 2px; color: #000000; padding: 1px; }textarea {margin-left:4px;  border-radius: 3px; border: 1px solid #486C93;  width: 95%; }ul { margin: 0; padding-left: 20px;}.alarm { background-color: #FF0000; color: #ffffff; font-weight: bold; padding:  4px;} .bb_panel {padding: 2px 10px; width: 97%} .bb_button{display: inline-block; padding: 2px 7px; margin: 2px 3px; font-variant: small-caps; font-size: 12pt; background: whitesmoke; vertical-align: middle; box-shadow: 0px 0px 3px #486C93; color: #486C93; text-decoration: none; border-radius: 3px;} .bblist { color: #4A5663; background: transparent url(../../images/dot.gif) no-repeat left; padding: 2px 0px 2px 10px;}.bmenu { background-color: #f5f5f5;background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAAeCAIAAABi9+OQAAAABmJLR0QAAAAAAAD5Q7t/AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAAPElEQVR42h3DyQ0AIAgAQfvvFW8EwYfJTjLlvVcykxHBey/dnWbGcw5VlXtvrrU45+QYg713ttZYa6WIfFvqVfYsk28DAAAAAElFTkSuQmCC); background-position: 10% 100%; background-repeat: repeat-x; border-bottom: 1px solid #DEDEDE; margin-bottom: 1px; margin: 0px; padding: 2px 4px 4px 4px;}.end { text-align: center;}.fmenu { background:#476185; color: #2d83da; margin: 0px 1px 0px 1px; padding: 5px 0px 5px 4px;}.fmenu a , .fmenu a:visited {color: #FBFCFF;}.header { background: #455c77; background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAAiCAIAAAARTyRGAAAABmJLR0QAAAAAAAD5Q7t/AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAAfElEQVR42gXBhxaBAABA0fdFJEm0l70qSgPHPPaxv9+9+MUPL//iZh/c9I0zf2EnT+z4gTW7Y05vmNEVI7ygB2f0yQltfEQdHVCHe5qDHY3+FqW3QemuqXdWyO0lcmtBzS+QvBzJzag6KaKdIFoxFXOGYEwR9IiyFlJSgz+/vh7iQwjDkQAAAABJRU5ErkJgtop-xgg==); background-position: 50% 100%; background-repeat: repeat-x; color: #fff; border-radius: 4px 4px 0px 0px; margin: 0px 1px 0px 1px; padding: 9px;}.footer { background: #455c77; border-radius: 0px 0px 4px 4px; margin: 0px 1px 0px 1px; padding: 6px;}.footer a , .footer a:visited { color:#fff; text-decoration: none;}.func { border-left: 4px solid #435A74; color: #757575; font-size: x-small; margin-left: 2px; margin-top: 4px; padding-left: 4px;}.gmenu {background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAIAAABCVLduAAAABmJLR0QAAAAAAAD5Q7t/AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAAs0lEQVR42g3Dh26CUABA0fv//2M01lSjqTVt3LXWxRRkC8gWsO8kh87iQncp0VtJ9NcybxuFwVbh/UdluNMYieO9zkT8+LsyPRh8Hg1mJ5Ov841vcS5ZLMSlbLNSHDaqw1Zz2ekev1ePveFzMH2Ot4CTeLHuSHaI7ESoboTmxeh+jBE8MEUrTLDDFCfKcOMM/5ETJDlhWhBlBXFekuQVafkkE4uqpnzWVHVD3TQ0bUvbvv4B8mqTfFHhD70AAAAASUVORK5CYII=); background-position: 100% 0%; background-repeat: repeat-x; margin: 0px; padding: 2px;}.gray { color: #586776;}.greply { border-left: 4px solid #009900; color: #009900; padding: 2px 0px 2px 4px;}.hdr { background-color: #f1f1f1; border-bottom: 1px solid #595959; font-weight: bold; padding-left: 2px;}.left { float: left;}.list1 { background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAAjCAIAAADaE/fjAAAABmJLR0QAAAAAAAD5Q7t/AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAAQklEQVR42iXDCwqAIBBAwb3/QQtN0TI/WboJb2BEVWVOjsH3Y+9sD0tTqWsua1VJmdfNmBhO+kgXaD2N435wM6vVHwczZWED52NXAAAAAElFTkSuQmCC); background-position: 30% 100%; background-repeat: repeat-x; background-color: #FFFFFF; border-bottom: 1px solid #ccc; margin-bottom: 1px; padding: 10px;}.list1 a:link , .list1 a:visited , .bmenu a , .bmenu a:visited{ color:#425872; text-decoration: none;}.list2 { background-color: #f5f5f5; background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAAeCAIAAABi9+OQAAAABmJLR0QAAAAAAAD5Q7t/AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAAPElEQVR42h3DyQ0AIAgAQfvvFW8EwYfJTjLlvVcykxHBey/dnWbGcw5VlXtvrrU45+QYg713ttZYa6WIfFvqVfYsk28DAAAAAElFTkSuQmCC); background-position: 50% 100%; background-repeat: repeat-x; border-bottom: 1px solid #ccc; margin-bottom: 1px; padding: 10px;}.list2 a:link , .list2 a:visited,  .user a , .user a:visited .sub a:link, .sub a:visited{text-shadow: -1px -1px 1px #eee; color:#425872; text-decoration: none;}.maintxt { background: #fff; border-right: 1px solid #DEDEDE; border-left: 1px solid #DEDEDE; box-shadow: 0px  10px  10px#ccc;}.menu { background: #fcfcfc; background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAAeCAIAAABi9+OQAAAABmJLR0QAAAAAAAD5Q7t/AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAAPElEQVR42h3DyQ0AIAgAQfvvFW8EwYfJTjLlvVcykxHBey/dnWbGcw5VlXtvrrU45+QYg713ttZYa6WIfFvqVfYsk28DAAAAAElFTkSuQmCC); background-position: 50% 100%; background-repeat: repeat-x; padding: 8px; border-bottom:1px solid #ccc; margin-bottom:1px;}.menu a:link , a:visited { color:#435A71; text-decoration: none;}.menu a:hover { padding-top:1px;text-decoration:underline;}.news { background-color: #EEEEEE; border: 1px solid white; color: #333333; font-size: x-small; padding: 3px 4px 4px 4px;}.phdr { color: #EAEAEA; background: #455c77; background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAAiCAIAAAARTyRGAAAABmJLR0QAAAAAAAD5Q7t/AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAAfElEQVR42gXBhxaBAABA0fdFJEm0l70qSgPHPPaxv9+9+MUPL//iZh/c9I0zf2EnT+z4gTW7Y05vmNEVI7ygB2f0yQltfEQdHVCHe5qDHY3+FqW3QemuqXdWyO0lcmtBzS+QvBzJzag6KaKdIFoxFXOGYEwR9IiyFlJSgz+/vh7iQwjDkQAAAABJRU5ErkJggg==); background-position: 50% 100%; background-repeat: repeat-x; padding: 10px; margin-top: -1px;}.phdr a { color: #fff;}.phpcode { background-color: #F8F9FF; border: 1px dashed #43526A; margin-top: 4px; padding: 3px; overflow: auto;}.quote { border-left: 4px solid #c0c0c0; color: #878787; font-size: x-small; margin-left: 2px; padding: 2px 0px 2px 4px;}.reply { border-left: 4px solid #EE0000; color: #EE0000; padding: 2px 0px 2px 4px;}.rmenu { background: #FCDDDD;  background-position:  50% 100%; background-repeat: repeat-x; padding: 6px; color:#624343;}.sitemap { font-size: xx-small; height: 0px; overflow: auto;}.status { color: #CD853F; font-size: x-small; font-weight: bold; padding-left: 0px;}.sub { border-top: 1px dotted #DEDEDE; font-size: x-small; margin-top: 4px;}.tmn { background: #476185; color: #E0E8F5; margin: 0px 1px 0px 1px; padding: 7px 0px 7px 4px;}.tmn a:link, .tmn a:visited { background: #fcfcfc; background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAASCAIAAAAVNSPrAAAABmJLR0QAAAAAAAD5Q7t/AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAAO0lEQVR42h3DyQ0AIAgAwe2/V7wRBB8mTjLce8lMIoJzDu6Omf17b1SVtRZzTsYYf++d1hq1VkopiMgDVLMzlGBt6iEAAAAASUVORK5CYII=); padding:2px ; margin-bottom: 6px; border:1px solid #CCCCCC; color:#5276A7; border-radius:3px;}.tmn a,visited { color:#1F2E40; text-decoration:none;}.topmenu { background: #455c77; padding: 5px; border-bottom: 1px solid #5385b8;}.topmenu a,visited , .rmenu a , .rmenu visited{ text-shadow: 0 0 2px #E3E5EA; color:#1F2E40; text-decoration:none;}.topmenu a:hover , .rmenu a:hover{ text-shadow: 0 0 2px #E3E5EA; color:#1F2E40; text-decoration:underline;}.user { background-color: #f5f5f5; background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAAeCAIAAABi9+OQAAAABmJLR0QAAAAAAAD5Q7t/AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAAPElEQVR42h3DyQ0AIAgAQfvvFW8EwYfJTjLlvVcykxHBey/dnWbGcw5VlXtvrrU45+QYg713ttZYa6WIfFvqVfYsk28DAAAAAElFTkSuQmCC); background-position: 0% 100%; background-repeat: repeat-x; margin-bottom: -4px; padding: 3px 4px 3px 4px;}.greply a:link, .greply a:visited { color: #008800;}.reply a:link, .reply a:visited { color: #DD0000;}.red {color: red;} .red a:link , .red a:visited{color: red;}input[type="submit"]{ background: #3F536C; border: 1px solid #3c73a7; border-radius:3px; color: #fff; margin:2px; padding:3px; font-size: 13px;}input {  margin-left:4px; border: 1px solid #486C93; border-radius: 3px;}.currentpage { background-color: #F1F3F5; border: 1px solid #334259; padding: 0px 5px 0px 5px;}a.pagenav { border: 1px solid #334259; padding: 0px 3px 0px 3px; text-decoration: none;}a.pagenav:hover { background-color: #f7f7f7; }'],
		/* Design by Cron/ ICQ 442494 */
		['Cron', 'body {background-color: #ffffff;color: #272726;font-family: Arial, Tahoma, sans-serif;font-size: small;margin: 0;padding: 0;}form {font-size: small;margin: 0;padding: 0;}h3 {margin: 0;padding: 0 0 2px 0;}hr {border: 0;border-top: 1px solid gray;margin: 0;}p {margin-bottom: 6px;margin-top: 6px;}textarea {width: 99%;}input, textarea, select {background: #fff;border: 1px solid #7ab158;color: #686868;padding: 3px;margin: 1px 2px;}select:focus {border: 2px solid #73c441;}input:hover {border: 1px solid #38800d;}ul {margin: 0;padding-left: 20px;}.alarm {background-color: #FF0000;border: 1px solid white;color: #ffffff;font-weight: bold;padding: 3px 0 3px 4px;}.bb_panel {padding: 2px 10px; width: 97%} .bb_button{display: inline-block; padding: 2px 7px; margin: 2px 3px; font-variant: small-caps; font-size: 12pt; background: whitesmoke; vertical-align: middle; box-shadow: 0px 0px 3px #489C63; color: #489C63; text-decoration: none; border-radius: 3px;}.bblist {color: #4A5663;background: transparent url(../../images/dot.gif) no-repeat left;padding: 0px 0px 0px 10px;}.bmenu {background-color: #ededed;background-image: url(data:image/gif;base64,R0lGODlhAQB4AMZIAOTk5OXk5eXl5ebl5ebm5ufm5ubn5ufn5+fn6Ojo5+jo6Ono6Onp6Onp6enq6urq6uvq6+rr6uvr6uvr6+vs6+vs7Ozs7Ozs7ezt7e3t7O3t7e3u7u7u7e7u7u7u7+7v7u/v7/Dv7+/w8PDw7/Dw8PHw8fHx8PHx8fLx8vLy8vLy8/Pz8/Tz8/P08/T09PT19PX19fX19vb19fb29vf29vb39/f39vf39/j39/j49/j4+Pj5+Pj5+fn5+fr5+fr5+vn6+fr6+vr6+/v6+vv7+/z7/Pz8/Pz9/P///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////ywAAAAAAQB4AAAHb4AAggECAgOFBAQFBwYHjggJCQoLkwwNDQ4Pmg8QERITExQVFqQXGBkaGxwdrB4fILAhICMiJCclJie6KSkoKikrwSstLC4uLy4wMDEwMjMzNDM2NzU5Nzg6OTo7PTw9QD49QT9CQ0FE6ERFRUZHgQA7);border: 1px solid white;margin: 0;padding: 2px 4px 4px 4px;}.end {text-align: center;}.fmenu {background: #5a5a5a;color: #FFFFFF;margin: 0;padding: 3px 1px 5px 3px;}.footer {background-color: #3b3a3a;background-image: url(data:image/gif;base64,R0lGODlhAgAaAKUvAC0rKy4tLS8uLTAvLzEvLzIxMTMxMTUyMjQzMzY0NTY1NDg2Njk5ODo5ODs6Ojs6Oz48PD48PT8+PkA+PkFAP0FAQENCQUNCQkVDREVEREZFRkdGRkhISElIR0pJSktKSU1LS01LTE5NTU9OTVBPT1FPT1JRUFNRUVRTU1VVVVZVVVdXVldXV1hXVlhXVyIgICIgICIgICIgICIgICIgICIgICIgICIgICIgICIgICIgICIgICIgICIgICIgICIgICwAAAAAAgAaAAAGMEBXy+VasVQpFOpkKpFGIlDo4+lwNhpMxnKpUCaSCOThaDAWC0XigDAUBgRBAAAIAgA7);border-bottom: 2px solid #1b1919;border-right: 1px solid #414040;border-left: 1px solid #414040;border-top: 1px solid #525151;color: #fff;margin: 0;padding: 5px 0 6px 4px;}.func {border-left: 4px solid #9acd32;color: #757575;font-size: x-small;margin-left: 2px;margin-top: 4px;padding-left: 4px;}.gmenu {background-color: #f0f8ec;border: 1px solid #dde8d8;margin: 0;padding: 3px 4px 3px 4px;}.gray {color: #586776;}.greply {border-left: 4px solid #009900;color: #009900;padding: 2px 0 2px 4px;}.hdr {background-color: #f1f1f1;border-bottom: 1px solid #595959;font-weight: bold;padding-left: 2px;}.header {background-color: #3b3a3a; background-image: url(data:image/gif;base64,R0lGODlhAgAaAKUvAC0rKy4tLS8uLTAvLzEvLzIxMTMxMTUyMjQzMzY0NTY1NDg2Njk5ODo5ODs6Ojs6Oz48PD48PT8+PkA+PkFAP0FAQENCQUNCQkVDREVEREZFRkdGRkhISElIR0pJSktKSU1LS01LTE5NTU9OTVBPT1FPT1JRUFNRUVRTU1VVVVZVVVdXVldXV1hXVlhXVyIgICIgICIgICIgICIgICIgICIgICIgICIgICIgICIgICIgICIgICIgICIgICIgICIgICwAAAAAAgAaAAAGMEBXy+VasVQpFOpkKpFGIlDo4+lwNhpMxnKpUCaSCOThaDAWC0XigDAUBgRBAAAIAgA7);border-top: 2px solid #4d4b4b;border-right: 1px solid #414040;border-left: 1px solid #414040;border-bottom: 1px solid #575656;color: #5b9637;margin: 0;padding: 5px 0 6px 4px;}.left {float: left;}.list1 {background-color: white;border: 1px solid white;margin: 0;padding: 3px 4px 4px 4px;}.list2 {background-color: #f7f7f7;border: 1px solid white;margin: 0;padding: 3px 4px 4px 4px;}.maintxt {border-right: 4px solid #5a5a5a;border-left: 4px solid #5a5a5a;border-bottom: 4px solid #5a5a5a;font-weight: normal;margin: 0;padding: 4px 4px 4px 4px;}.menu {background: #fbfbfb;color: #626262;border: 1px solid white;margin: 0;padding: 3px 4px 3px 4px;}.news {background-color: #f4f9f1;border-left: 1px solid #eaeaea;border-right: 1px solid #eaeaea;border-bottom: 1px solid #d3e7c7;color: #333333;font-size: small;padding: 3px 4px 4px 4px;}.news a:link, .news a:visited {text-decoration: underline;}.news a:hover {color: green;}.phdr {color: #629d3e;font-weight: bold;background-color: #d5d5d5;background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAAYCAIAAABfmbuOAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9sLHREcDn2lQQIAAAAZdEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVBXgQ4XAAAATklEQVQI102NMQ4DQQyEsOT//3bLhRSXi1JNAWLmnANsFq3KsCax6sME9uYwm4SbRms3WO3PtKK93nnTX6WtS+y1h9k7sxrT7z1hVh34ABYrV72yJkPTAAAAAElFTkSuQmCC);border: 2px solid;border-color: #eaeaea;padding: 3px 4px 3px 4px;}.phpcode {background-color: #e4e9e0;border: 1px dotted #d3e0c7;margin-top: 4px;padding: 0 2px 0 2px;overflow: auto;}.quote {border-left: 4px solid #c0c0c0;color: #878787;font-size: x-small;margin-left: 2px;padding: 2px 0 2px 4px;}.reply {border-left: 4px solid #EE0000;color: #EE0000;padding: 2px 0 2px 4px;}.rmenu {background-color: #e9ccd2;border: 1px solid white;margin: 0;padding: 2px 0 3px 4px;}.sitemap {background-color: #eef1e8;margin: 0;padding: 2px 4px 3px 4px;font-size: xx-small;height: 38px;overflow: auto;}.status {color: #4e7c32;font-size: x-small;font-weight: bold;padding-left: 0;}.sub {border-top: 1px dotted #dfead7;font-size: x-small;margin-top: 4px;}.tmn {background-color: #646464; background-image: url(data:image/gif;base64,R0lGODlhAgAZAKUoADQyMjUzMzU0NDc1NTg3Njk3Nzo4OTo5ODw5Ojw6OT07Oz47PD49PT89PUA+P0JAQUJBQUNCQkRCQkVDREdFRUhGRkhHR0pISEtJSkxJSk1LTE1MTE5NTU9NTVBOT1FOT1JQUFRSUVRSUlVTU1VUU1dVVVhXVlhXV////////////////////////////////////////////////////////////////////////////////////////////////ywAAAAAAgAZAAAGLUAAICAYDAiFgwGRUCwYDYfjAYlIJtgJhVKxXC6YjGbT4Xw8IJAoNCKVSqZTEAA7);border-top: 1px solid #171616;color: #ffffff;margin: 0;padding: 5px 0 5px 4px;}.topmenu {font-size: x-small;padding: 2px 4px 3px 4px;margin-bottom: 1px;background-color: #f4f9f1;border-left: 1px solid #eaeaea;border-right: 1px solid #eaeaea;border-bottom: 1px solid #d3e7c7;}.topmenu input{font-size: x-small}.user {background-color: #f0fde8;border: 1px solid #dfefd2;margin: 0;padding: 3px 4px 3px 4px;}.alarm a:link, .alarm a:visited {color: #FFFFFF;font-size: x-small;}.clip a:link, .clip a:visited {color: #424e59;}.footer a:link, .footer a:visited {color: #fff;text-decoration: none;}.green, .green a:link, .green a:visited {color: #008000;}.greply a:link, .greply a:visited {color: #008800;}.red, .red a:link, .red a:visited {color: #FF0000;}.reply a:link, .reply a:visited {color: #DD0000;}.sub a:link, .sub a:visited {}.tmn a:link, .tmn a:visited, .fmenu a:link, .fmenu a:visited {color: #FFFFFF;text-decoration: none;}.footer a:hover, .tmn a:hover{color: #5b9637;text-decoration: none;}.fmenu a:hover {color: #5b9637;text-decoration: none;}a:active {color: #353535;text-decoration: none;}a:link, a:visited {color: #353535;text-decoration: none;}a:hover {color: #5b9637;text-decoration: none;}.currentpage {color: #59ab28;background-color: #edebeb;border: 1px solid #cccccc;padding: 0px 5px 0px 5px;}a.pagenav {border: 1px solid #cccccc;padding: 0px 3px 0px 3px;text-decoration: none;}a.pagenav:hover {background-color: #f7f7f7;border: 1px solid #dedede;}']
	];
	return styles;
}