<?php
/***************************************************************************
 *                              rules.php
 *                            -------------------
 *  Разработка и оптимизация под WAP: Гутник Игорь ( чел )
 *            2009 год
 ***************************************************************************/

/***************************************************************************
 *
 *   Эта версия phpBB-WAP является бесплатным
 *   программным обеспечением и распространяется
 *   в рамках лицензии GNU General Public License.
 *   Автор модификации настоятельно не
 *   рекомендует распрострянять её так, как
 *   распространялась 5 версия мода.
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

$forum_id = get_var('f', 0);
$privmsg = (!$forum_id) ? true : false;

$userdata = session_pagestart($user_ip, PAGE_PRAVILA);
init_userprefs($userdata);

if ( isset($HTTP_GET_VARS['mode']) )
{
	$mode = htmlspecialchars($HTTP_GET_VARS['mode']);
} else {
	$mode = '';
}

if ( $mode == 'attach' )
{
	if ($privmsg)
	{
		$auth['auth_attachments'] = ($userdata['user_level'] != ADMIN) ? intval($attach_config['allow_pm_attach']) : true;
		$auth['auth_view'] = true;
		$_max_filesize = $attach_config['max_filesize_pm'];
	}
	else
	{
		$auth = auth(AUTH_ALL, $forum_id, $userdata);
		$_max_filesize = $attach_config['max_filesize'];
	}

	if (!($auth['auth_attachments'] && $auth['auth_view']))
	{
		message_die(GENERAL_ERROR, 'You are not allowed to call this file (ID:2)');
	}

	$page_title = $lang['Attach_rules_title'];
	include($phpbb_root_path . 'includes/page_header.' . $phpEx);

	$template->set_filenames(array(
		'body' => 'posting_attach_rules.tpl')
	);

	$sql = 'SELECT group_id, group_name, max_filesize, forum_permissions
		FROM ' . EXTENSION_GROUPS_TABLE . ' 
		WHERE allow_group = 1 
		ORDER BY group_name ASC';

	if (!($result = $db->sql_query($sql)))
	{ 
		message_die(GENERAL_ERROR, 'Could not query Extension Groups.', '', __LINE__, __FILE__, $sql); 
	} 

	$allowed_filesize = array(); 
	$rows = $db->sql_fetchrowset($result); 
	$num_rows = $db->sql_numrows($result); 
	$db->sql_freeresult($result);

	$nothing = true;
	for ($i = 0; $i < $num_rows; $i++)
	{
		$auth_cache = trim($rows[$i]['forum_permissions']);
		$permit = ($privmsg) ? true : ((is_forum_authed($auth_cache, $forum_id)) || trim($rows[$i]['forum_permissions']) == '');

		if ($permit)
		{
			$nothing = false;
			$group_name = $rows[$i]['group_name'];
			$f_size = intval(trim($rows[$i]['max_filesize']));
			$det_filesize = (!$f_size) ? $_max_filesize : $f_size;
			$size_lang = ($det_filesize >= 1048576) ? $lang['MB'] : (($det_filesize >= 1024) ? $lang['KB'] : $lang['Bytes']); 

			if ($det_filesize >= 1048576) 
			{
				$det_filesize = round($det_filesize / 1048576 * 100) / 100; 
			}
			else if ($det_filesize >= 1024) 
			{ 
				$det_filesize = round($det_filesize / 1024 * 100) / 100; 
			} 

			$max_filesize = ($det_filesize == 0) ? $lang['Unlimited'] : $det_filesize . ' ' . $size_lang;

			$template->assign_block_vars('group_row', array(
				'GROUP_RULE_HEADER' => sprintf($lang['Group_rule_header'], $group_name, $max_filesize))
			);

			$sql = 'SELECT extension
				FROM ' . EXTENSIONS_TABLE . " 
				WHERE group_id = " . (int) $rows[$i]['group_id'] . " 
				ORDER BY extension ASC";

			if (!($result = $db->sql_query($sql))) 
			{ 
				message_die(GENERAL_ERROR, 'Could not query Extensions.', '', __LINE__, __FILE__, $sql); 
			} 

			$e_rows = $db->sql_fetchrowset($result);
			$e_num_rows = $db->sql_numrows($result);
			$db->sql_freeresult($result);

			for ($j = 0; $j < $e_num_rows; $j++)
			{
				$template->assign_block_vars('group_row.extension_row', array(
					'EXTENSION' => $e_rows[$j]['extension'])
				);
			}
		}
	}

	$template->assign_vars(array(
		'L_RULES_TITLE'			=> $lang['Attach_rules_title'],
		'L_CLOSE_WINDOW'		=> $lang['Close_window'],
		'L_EMPTY_GROUP_PERMS'	=> $lang['Note_user_empty_group_permissions'])
	);

	if ($nothing)
	{
		$template->assign_block_vars('switch_nothing', array());
	}

	$template->pparse('body');
	include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
	exit;
}

$id = ( isset($HTTP_GET_VARS['id']) ) ? intval($HTTP_GET_VARS['id']) : '';

switch( $id )
{
	case '7':
	$print = '<p><a href="index.php">Форумы</a>|Информация</p><table width="100%" cellpadding="4" cellspacing="0" border="0" class="forumline"><tr><td class="catSides"><span class="cattitle">Таблица транслита</span></td></tr><tr><td class="row1">"Sch" => "Щ", "sch" => "щ"<br/>"Yu" => "Ю", "yu" => "ю"<br/>"Ju" => "Ю", "ju" => "ю"<br/>"Ya" => "Я", "ya" => "я"<br/>"Ja" => "Я", "ja" => "я"<br/>"Yo" => "Ё", "yo" => "ё"<br/>"Jo" => "Ё", "jo" => "ё"<br/>"Zh" => "Ж", "zh" => "ж"<br/>"Ch" => "Ч", "ch" => "ч"<br/>"Sh" => "Ш", "sh" => "ш"<br/>"Ts" => "Ц", "ts" => "ц"<br/>"E\'" => "Э", "e\'" => "э"<br/>"A"=>"А", "a"=>"а"<br/>"B"=>"Б", "b"=>"б"<br/>"C"=>"Ц", "c"=>"ц"<br/>"D"=>"Д", "d"=>"д"<br/>"E"=>"Е", "e"=>"е"<br/>"F"=>"Ф", "f"=>"ф"<br/>"G"=>"Г", "g"=>"г"<br/>"H"=>"Х", "h"=>"х"<br/>"I"=>"И", "i"=>"и"<br/>"J"=>"Й", "j"=>"й"<br/>"K"=>"К", "k"=>"к"<br/>"L"=>"Л", "l"=>"л"<br/>"M"=>"М",  "m"=>"м"<br/>"N"=>"Н", "n"=>"н"<br/>"O"=>"О", "o"=>"о"<br/>"P"=>"П", "p"=>"п"<br/>"R"=>"Р", "r"=>"р"<br/>"S"=>"С", "s"=>"с"<br/>"T"=>"Т", "t"=>"т"<br/>"U"=>"У", "u"=>"у"<br/>"V"=>"В", "v"=>"в"<br/>"W"=>"В", "w"=>"в"<br/> "Y"=>"Ы", "y"=>"ы"<br/>"Z"=>"З", "z"=>"з"<br/>"``"=>"Ъ", "`"=>"ъ"</td></tr></table>';
	break;
	case '6':
	$print = '<p><a href="index.php">Форумы</a>|Информация</p><table width="100%" cellpadding="4" cellspacing="0" border="0" class="forumline"><tr><td class="catSides"><span class="cattitle">Автологин</span></td></tr><tr><td class="row1">Чтобы каждый раз при входе на форум не вводить свой логин и пароль, можете создать закладку:<br/>http://'.$board_config['server_name'].$board_config['script_path'].'login.php?username=ваш_логин&password=ваш_пароль<br/>, где "ваш_логин" и "ваш_пароль" заменяете на свои логин и пароль.</td></tr></table>';
	break;
	case '5':
	$print = '<p><a href="index.php">Форумы</a>|Правила</p><table width="100%" cellpadding="4" cellspacing="0" border="0" class="forumline"><tr><td class="catSides"><span class="cattitle">Наказания</span></td></tr><tr><td class="row1">За выполнением требований Правил следит администрация, а также специально назначенные модераторы. Администрация имеет право не предупреждать пользователя о принимаемых мерах.<br/>1.Сообщения, содержащие нецензурную лексику, прямые оскорбления в адрес любого пользователя форума, удаляются.<br/>2.Модератор может закрыть любую тему (или удалить ее), если считает, что дальнейшая дискуссия не приведет ни к чему, кроме конфликта.<br/>3.В ситуациях, не оговоренных Правилами, модератор принимает решение сообразно своим ценностным установкам.<br/>4.Если участник пренебрегает данными Правилами, его аккуант блокируется сроком от 5 минут до 7 дней.<br/>5.Если участник систематически игнорирует просьбы администрации, то его учётная запись удаляется.</td></tr></table>';
	break;
	case '4':
	$print = '<p><a href="index.php">Форумы</a>|Правила</p><table width="100%" cellpadding="4" cellspacing="0" border="0" class="forumline"><tr><td class="catSides"><span class="cattitle">Создание сообщения</span></td></tr><tr><td class="row1">Запрещается помещение сообщений, содержащих:<br/>1.Призывы к нарушению действующего законодательства, высказывания расистского характера, разжигание межнациональной розни, нагнетание обстановки на форуме и всего прочего, что попадает под действие УК РФ.<br/>2.Грубые, нецензурные выражения и оскорбления в любой форме (флейм) - сообщения, грубые по тону, содержащие "наезды" на личности.<br/>3.Бессмысленную или малосодержательную информацию, которая не несет смысловой нагрузки - пустую болтовню (флуд).<br/>4.Оффтоп, т.е. уход от основного обсуждения в рамках отдельной темы.<br/>5.Заведомо ложнyю инфоpмацию, клеветy.<br/>6.Откровенное рекламное содержание, в том числе с просьбой "Посетите/оцените мой сайт" (для этого есть соответствующий раздел).<br/>7.Безосновательные утверждения, что "это" лучше, а "это" хуже. Сюда же относятся сообщения типа "выкинь бяку, купи хорошую вещь".<br/>8.Чрезмерное количество анимированных картинок, мешающих нормальному восприятию текста.<br/>9.Чрезмерное количество грамматических ошибок и жаргонных слов.</td></tr></table>';
	break;
	case '3':
	$print = '<p><a href="index.php">Форумы</a>|Правила</p><table width="100%" cellpadding="4" cellspacing="0" border="0" class="forumline"><tr><td class="catSides"><span class="cattitle">Создание темы</span></td></tr><tr><td class="row1">Запрещается создание новых тем:<br/>1.Сразу в нескольких форумах одновременно.<br/>2.Имеющих в названии украшения типа &lt;==--Самая актуальная тема--==&gt;.<br/>3.Имеющих малосодержательное название, например, "Нужна помощь!!!" или "Есть вопрос".<br/>4.Обращенных к конкретным участникам конференции (для этого существует "личка" ЛС).<br/>5.Запрещается создавать дубликаты тем. Если тема с подобным названием уже была в форуме (особенно недавно), пишите в нее же свои вопросы и/или ответы.<br/>6.Продолжение обсyждений вопросов из тем, закpытых/удалённых администрацией.<br/>Перед тем как задать вопрос, настоятельно рекомендуем пользоваться FAQ и поиском по форуму, наверняка Ваш вопрос уже обсуждался ранее.<br/>7.Если вы хотите добавить что-то нужное в уже закрытую тему,сообщите об этом модератору соответствующего форума.</td></tr></table>';
	break;
	case '2':
	$print = '<p><a href="index.php">Форумы</a>|Правила</p><table width="100%" cellpadding="4" cellspacing="0" border="0" class="forumline"><tr><td class="catSides"><span class="cattitle">Имя пользователя</span></td></tr><tr><td class="row1">1.Запрещается использовать в имени адреса сайтов, номера телефонов, грубые и нецензурные выражения.<br/>2.Запрещается использовать ники, состоящие из цифр или служебных символов более чем на 80%.<br/>3.Запрещается регистрировать более 3 ников на одного человека. При выявлении избытка регистраций учетные записи будут удаляться без предупреждения.</td></tr></table>';
	break;
	case '1':
	$print = '<p><a href="index.php">Форумы</a>|Правила</p><table width="100%" cellpadding="4" cellspacing="0" border="0" class="forumline"><tr><td class="catSides"><span class="cattitle">Общее</span></td></tr><tr><td class="row1">Все сообщения отражают мнения их авторов, и администрация никакой ответственности за них не несёт.<br/>Обязательны:<br/>1.Уважительное отношение к собеседнику, правильное (грамотное) и доходчивое изложение мыслей и фактов.<br/>2.Не ранжирование людей по принципу приверженности той или иной марки телефона.<br/>Не обращайте внимания на маргиналов и прочих брутальных личностей. Не дразните и не подначивайте их - отсутствие внимания сразу сводит дискуссию на нет. Не стоит отвечать им той же монетой, даже если Вы считаете, что Вас оскорбили. Остальное - забота модераторов и администраторов.<br/>Если Вы видите сообщение, нарушающее любое правило форума, сообщите об этом администрации по электронной почте или в «личку», не стоит об этом кричать на форуме во всеуслышанье.</td></tr></table>';
	break;
	default:
	$print = '<p><a href="index.php">Форумы</a>|Правила</p><table width="100%" cellpadding="4" cellspacing="0" border="0" class="forumline"><tr><td class="catSides"><span class="cattitle">Правила</span></td></tr><tr><td class="row1">Незнание этих Правил форума не только не освобождает Вас от ответственности за их нарушение, но и само по себе является нарушением!</td></tr><tr><td class="row1">- <a href="rules.php?id=1">Общие рекомендации</a><br/>- <a href="rules.php?id=2">Имя пользователя</a><br/>- <a href="rules.php?id=3">Создание темы</a><br/>- <a href="rules.php?id=4">Создание сообщения</a><br/>- <a href="rules.php?id=5">Наказания</a></td></tr</table>';
	break;
}

$page_title = 'Правила';
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'pravila.tpl')
);

$template->assign_vars(array(
	'PRAVILA' => $print)
);

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>