<?php

/**
* @package     JohnCMS
* @link        http://johncms.com
* @copyright   Copyright (C) 2008-2011 JohnCMS Community
* @license     LICENSE.txt (see attached file)
* @version     VERSION.txt (see attached file)
* @author      http://johncms.com/about
*/

defined('_IN_JOHNCMS') or die('Error: restricted access');

$textl = htmlspecialchars($user['name']) . ': ' . $lng_profile['profile_edit'];
require('../incfiles/head.php');

/*
-----------------------------------------------------------------
Проверяем права доступа для редактирования Профиля
-----------------------------------------------------------------
*/
if ($user['id'] != $user_id && ($rights < 7 || $user['rights'] > $rights)) {
    echo functions::display_error($lng_profile['error_rights']);
    require('../incfiles/end.php');
    exit;
}

/*
-----------------------------------------------------------------
Сброс настроек
-----------------------------------------------------------------
*/
if ($rights >= 7 && $rights > $user['rights'] && $act == 'reset') {
    mysql_query("UPDATE `users` SET `set_user` = '', `set_forum` = '', `set_chat` = '' WHERE `id` = '" . $user['id'] . "'");
    echo '<div class="gmenu">' . $lng['settings_default'] . '<br /><a href="profile.php?user=' . $user['id'] . '">' . $lng['to_form'] . '</a></div>';
    require('../incfiles/end.php');
    exit;
}
echo '<div class="title2">' . $lng['edit'] . '</div>';

if (isset($_GET['delavatar'])) {
    /*
    -----------------------------------------------------------------
    Удаляем аватар
    -----------------------------------------------------------------
    */
    @unlink('../files/users/avatar/' . $user['id'] . '.png');
    echo '<div class="rmenu">' . $lng_profile['avatar_deleted'] . '</div>';
} elseif (isset($_GET['delphoto'])) {
    /*
    -----------------------------------------------------------------
    Удаляем фото
    -----------------------------------------------------------------
    */
    @unlink('../files/users/photo/' . $user['id'] . '.jpg');
    @unlink('../files/users/photo/' . $user['id'] . '_small.jpg');
    echo '<div class="rmenu">' . $lng_profile['photo_deleted'] . '</div>';
} elseif (isset($_POST['submit'])) {
    /*
    -----------------------------------------------------------------
    Принимаем данные из формы, проверяем и записываем в базу
    -----------------------------------------------------------------
    */
    $error = array ();
    $user['imname'] = isset($_POST['imname']) ? functions::check(mb_substr($_POST['imname'], 0, 25)) : '';
	$user['rost'] = isset($_POST['rost']) ? intval($_POST['rost']) : 0;
    $user['ves'] = isset($_POST['ves']) ? intval($_POST['ves']) : 0;
    $user['live'] = isset($_POST['live']) ? functions::check(mb_substr($_POST['live'], 0, 50)) : '';
	$user['glaza'] = isset($_POST['glaza']) ? functions::check(mb_substr($_POST['glaza'], 0, 15)) : '';
    $user['dayb'] = isset($_POST['dayb']) ? intval($_POST['dayb']) : 0;
    $user['monthb'] = isset($_POST['monthb']) ? intval($_POST['monthb']) : 0;
    $user['yearofbirth'] = isset($_POST['yearofbirth']) ? intval($_POST['yearofbirth']) : 0;
    $user['about'] = isset($_POST['about']) ? functions::check(mb_substr($_POST['about'], 0, 500)) : '';
	$user['glaza'] = isset($_POST['glaza']) ? functions::check(mb_substr($_POST['glaza'], 0, 15)) : '';
	$user['lovebook'] = isset($_POST['lovebook']) ? functions::check(mb_substr($_POST['lovebook'], 0, 150)) : '' ;
	$user['lovefilms'] = isset($_POST['lovefilms']) ? functions::check(mb_substr($_POST['lovefilms'], 0, 150)) : '' ;
	$user['lovemuzic'] = isset($_POST['lovemuzic']) ? functions::check(mb_substr($_POST['lovemuzic'], 0, 150)) : '' ;
    $user['mibile'] = isset($_POST['mibile']) ? functions::check(mb_substr($_POST['mibile'], 0, 40)) : '';
    $user['mail'] = isset($_POST['mail']) ? functions::check(mb_substr($_POST['mail'], 0, 40)) : '';
    $user['mailvis'] = isset($_POST['mailvis']) ? 1 : 0;
    $user['icq'] = isset($_POST['icq']) ? intval($_POST['icq']) : 0;
    $user['skype'] = isset($_POST['skype']) ? functions::check(mb_substr($_POST['skype'], 0, 40)) : '';

    
    // Данные юзера (для Администраторов)
    $user['name'] = isset($_POST['name']) ? functions::check(mb_substr($_POST['name'], 0, 20)) : $user['name'];
    $user['status'] = isset($_POST['status']) ? functions::check(mb_substr($_POST['status'], 0, 50)) : '';
    $user['karma_off'] = isset($_POST['karma_off']);
    $user['sex'] = isset($_POST['sex']) && $_POST['sex'] == 'm' ? 'm' : 'zh';
    $user['rights'] = isset($_POST['rights']) ? abs(intval($_POST['rights'])) : $user['rights'];
    // Проводим необходимые проверки
    if($user['rights'] > $rights || $user['rights'] > 9 || $user['rights'] < 0)
        $user['rights'] = 0;
    if ($rights >= 7) {
        if (mb_strlen($user['name']) < 2 || mb_strlen($user['name']) > 20)
            $error[] = $lng_profile['error_nick_lenght'];
        $lat_nick = functions::rus_lat(mb_strtolower($user['name']));
        if (preg_match("/[^0-9a-z\-\@\*\(\)\?\!\~\_\=\[\]]+/", $lat_nick))
            $error[] = $lng_profile['error_nick_symbols'];
    }
    if ($user['dayb'] || $user['monthb'] || $user['yearofbirth']) {
        if ($user['dayb'] < 1 || $user['dayb'] > 31 || $user['monthb'] < 1 || $user['monthb'] > 12)
            $error[] = $lng_profile['error_birth'];
    }
    if ($user['icq'] && ($user['icq'] < 10000 || $user['icq'] > 999999999))
        $error[] = $lng_profile['error_icq'];
    if (!$error) {
        mysql_query("UPDATE `users` SET
            `imname` = '" . $user['imname'] . "',
            `live` = '" . $user['live'] . "',
            `dayb` = '" . $user['dayb'] . "',
			`rost` = '" . $user['rost'] . "',
			`ves` = '" . $user['ves'] . "',
			`glaza` = '" . $user['glaza'] . "',
            `monthb` = '" . $user['monthb'] . "',
            `yearofbirth` = '" . $user['yearofbirth'] . "',
            `about` = '" . $user['about'] . "',
			`lovemuzic` = '" . $user['lovemuzic'] ."',
            `lovefilms` = '" . $user['lovefilms'] ."',
			`lovebook` = '" . $user['lovebook'] ."',
            `mibile` = '" . $user['mibile'] . "',
            `mail` = '" . $user['mail'] . "',
            `mailvis` = '" . $user['mailvis'] . "',
            `icq` = '" . $user['icq'] . "',
            `skype` = '" . $user['skype'] . "',

            `www` = '" . $user['www'] . "'
            WHERE `id` = '" . $user['id'] . "'
        ");
        if ($rights >= 7) {
            mysql_query("UPDATE `users` SET
                `name` = '" . $user['name'] . "',
                `status` = '" . $user['status'] . "',
                `karma_off` = '" . $user['karma_off'] . "',
                `sex` = '" . $user['sex'] . "',
                `rights` = '" . $user['rights'] . "'
                WHERE `id` = '" . $user['id'] . "'
            ");
        }
        echo '<div class="menu">' . $lng_profile['data_saved'] . '</div>';
    } else {
        echo functions::display_error($error);
    }
    header('Location: profile.php?act=edit&user=' . $user['id']);
    exit;
}

/*
-----------------------------------------------------------------
Форма редактирования анкеты пользователя
-----------------------------------------------------------------
*/
echo '<form action="profile.php?act=edit&amp;user=' . $user['id'] . '" method="post">' .
        '<div class="menu">' . $lng['login_name'] . ': <b>' . $user['name_lat'] . '</b></div>';
if ($rights >= 7) {
    echo '<div class="menu"><small>' . $lng['nick'] . ': (' . $lng_profile['nick_lenght'] . ')</small><br /><input type="text" value="' . $user['name'] . '" name="name" /></div>';
     echo '<div class="menu"><small>' . $lng['status'] . ': (' . $lng_profile['status_lenght'] . ')</small><br /><input type="text" value="' . $user['status'] . '" name="status" /></div>';
} else {
    echo '<div class="menu"><span class="gray">' . $lng['nick'] . ': </span><b>' . $user['name'] . '</b></div>' .
            '<div class="menu"><span class="gray">' . $lng['status'] . ':</span> ' . $user['status'] . '</div>';
}
echo '<div class="title2">' . $lng['avatar'] . '</div>';
$link = '';
if (file_exists(('../files/users/avatar/' . $user['id'] . '.png'))) {
    echo '<div class="menu"><img src="../files/users/avatar/' . $user['id'] . '.png" width="32" height="32" alt="' . $user['name'] . '" /></div>';
 $link = '<div class="menu"><a href="profile.php?act=edit&amp;user=' . $user['id'] . '&amp;delavatar">' . $lng['delete'] . '</a></div>';
}else {
echo '<div class="menu"><img src="../users/img/empty.png" alt="img" width="32" height="32" /></div>';
}
   
echo '<div class="menu"><a href="profile.php?act=images&amp;mod=avatar&amp;user=' . $user['id'] . '">' . $lng_profile['upload'] . '</a></div>';
if($user['id'] == $user_id)
    echo '<div class="menu"><a href="../pages/faq.php?act=avatars">' . $lng['select'] . '</a></div>';
echo $link . '';

echo '<div class="title2">' . $lng_profile['photo'] . '</div>';
$link = '';
if (file_exists(('../files/users/photo/' . $user['id'] . '_small.jpg'))) {
      echo '<div class="menu"><a href="../files/users/photo/' . $user['id'] . '.jpg"><img src="../../files/users/photo/' . $user['id'] . '_small.jpg" alt="' . $user['name'] . '" border="0" /></a></div>';
   $link = '</div><div class="menu"><a href="profile.php?act=edit&amp;user=' . $user['id'] . '&amp;delphoto">' . $lng['delete'] . '</a>';
}else {
      echo '<div class="menu"><img src="../users/img/nofoto.png" alt="img" width="128" height="128" /></div>';
}
 echo '<div class="menu"><a href="profile.php?act=images&amp;mod=up_photo&amp;user=' . $user['id'] . '">' . $lng_profile['upload'] . '</a>' . $link . ' </div>';    

      echo '<div class="title2">' . $lng_profile['personal_data'] . '</div>' .
              '<div class="menu">' . $lng_profile['name'] . ':<br /><input type="text" value="' . $user['imname'] . '" name="imname" /></div>' .
              '<div class="menu">' . $lng_profile['birth_date'] . '<br />' .
              '<input type="text" value="' . $user['dayb'] . '" size="2" maxlength="2" name="dayb" />.' .
              '<input type="text" value="' . $user['monthb'] . '" size="2" maxlength="2" name="monthb" />.' .
              '<input type="text" value="' . $user['yearofbirth'] . '" size="4" maxlength="4" name="yearofbirth" /></div>' .
              '<div class="menu">' . $lng_profile['city'] . ':<br /><input type="text" value="' . $user['live'] . '" name="live" /></div>' .

                 '<div class="title2">Интересы</div>' .
	'<div class="menu">Любимые книги: <br /> <input type="text" value="' . $user['lovebook'] . '" name="lovebook" /></div>'.
	'<div class="menu">Любимая музыка: <br /> <input type="text" value="' . $user['lovemuzic'] . '" name="lovemuzic" /></div>'.
	'<div class="menu">Любимые фильмы: <br /> <input type="text" value="' . $user['lovefilms'] . '" name="lovefilms" /></div>'.
                 '<div class="menu">' . $lng_profile['about'] . ':<br /><textarea rows="' . $set_user['field_h'] . '" name="about">' . $user['about'] . '</textarea></div>' .
                 '<div class="title2">Внешность</div>' .
	'<div class="menu">Рост:<br /><input type="text" value="' . $user['rost'] . '" size="4" maxlength="4" name="rost" /></div>'.
	'<div class="menu">Вес:<br /><input type="text" value="' . $user['ves'] . '" size="4" maxlength="4" name="ves" /></div>'.
	'<div class="menu">Глаза:<br /><input type="text" value="' . $user['glaza'] . '" name="glaza" /></div>'.

    '<div class="title2">Связь</div>' .
    '<div class="menu">' . $lng_profile['phone_number'] . ':<br /><input type="text" value="' . $user['mibile'] . '" name="mibile" /></div>' .
    '<div class="menu">E-mail:<br />' .
    '<input type="text" value="' . $user['mail'] . '" name="mail" />' .
    '<p><input name="mailvis" type="checkbox" value="1" ' . ($user['mailvis'] ? 'checked="checked"' : '') . ' />&#160;' . $lng_profile['show_in_profile'] . '</p>' .
    '<p><small>' . $lng_profile['email_warning'] . '</small></p></div>' .
    '<div class="menu">ICQ:<br /><input type="text" value="' . $user['icq'] . '" name="icq" size="10" maxlength="10" /></div>' .
    '<div class="menu">Skype:<br /><input type="text" value="' . $user['skype'] . '" name="skype" /></div>';

// Административные функции
if ($rights >= 7) {
    echo '<div class="title3">' . $lng['settings'] . '</div>';
    if ($rights == 9) {
        echo '<div class="menu"><input name="karma_off" type="checkbox" value="1" ' . ($user['karma_off'] ? 'checked="checked"' : '') . ' />&#160;<span class="red">' . $lng_profile['deny_karma'] . '</span></div>';
    }
    echo '<div class="menu"><span class="red"><a href="profile.php?act=password&amp;user=' . $user['id'] . '">' . $lng['change_password'] . '</a></span></div>';
    if($rights > $user['rights'])
        echo '<div class="menu"><span class="red"><a href="profile.php?act=reset&amp;user=' . $user['id'] . '">' . $lng['reset_settings'] . '</a></span></div>';
    echo '<div class="menu"><span class="red">' . $lng_profile['specify_sex'] . ':</span><br />' .
        '<input type="radio" value="m" name="sex" ' . ($user['sex'] == 'm' ? 'checked="checked"' : '') . '/>&#160;<span class="red">' . $lng_profile['sex_m'] . '</span><br />' .
        '<input type="radio" value="zh" name="sex" ' . ($user['sex'] == 'zh' ? 'checked="checked"' : '') . '/>&#160;<span class="red">' . $lng_profile['sex_w'] . '</span></div>';
        
    if ($user['id'] != $user_id) {
        echo '<div class="title3">' . $lng_profile['rank'] . '</div>' .
            '<div class="menu"><input type="radio" value="0" name="rights" ' . (!$user['rights'] ? 'checked="checked"' : '') . '/>&#160;<span class="red">' . $lng_profile['rank_0'] . '</span><br />' .
            '<input type="radio" value="3" name="rights" ' . ($user['rights'] == 3 ? 'checked="checked"' : '') . '/>&#160;<span class="red">' . $lng_profile['rank_3'] . '</span><br />' .
            '<input type="radio" value="4" name="rights" ' . ($user['rights'] == 4 ? 'checked="checked"' : '') . '/>&#160;<span class="red">' . $lng_profile['rank_4'] . '</span><br />' .
            '<input type="radio" value="5" name="rights" ' . ($user['rights'] == 5 ? 'checked="checked"' : '') . '/>&#160;<span class="red">' . $lng_profile['rank_5'] . '</span><br />' .
            '<input type="radio" value="6" name="rights" ' . ($user['rights'] == 6 ? 'checked="checked"' : '') . '/>&#160;<span class="red">' . $lng_profile['rank_6'] . '</span><br />';
        if ($rights == 9) {
            echo '<input type="radio" value="7" name="rights" ' . ($user['rights'] == 7 ? 'checked="checked"' : '') . '/>&#160;<span class="red">' . $lng_profile['rank_7'] . '</span><br />' .
                    '<input type="radio" value="9" name="rights" ' . ($user['rights'] == 9 ? 'checked="checked"' : '') . '/>&#160;<span class="red">' . $lng_profile['rank_9'] . '</span>';
        }
    echo'</div>';
    }
    
}
echo '<div class="gmenu"><input type="submit" value="' . $lng['save'] . '" name="submit" /></div>' .
'</form>'.
      
        '<div class="title2">Меню</div>' .
        '<div class="phdr"><a href="profile.php?user=' . $user['id'] . '">' . $lng['to_form'] . '</a></div>';
?>