<?php

/**
 * Conference for JohnCMS
 * Download log
 * @author Screamer
 * @copyright 2013
 */

/**
 * Download log
 * @param (int) $id ID of conference
 * @return (void)
 */
function action_download($sys, $id = 0) {
	$id = str_replace('.txt', '', $id);
	$id = intval($id);
	$data = $sys->jl->model('conference')->get($id);
	if (!empty($data)) {
		$get_messages = $sys->jl->model('messages')->get_list($id);
		$time = time() + ( $sys->jl->get_data('user_settings', 'timeshift') + $sys->jl->get_data('system_settings', 'timeshift') ) * 3600;
		$messages = 'Conference Log: ' . $data['name'] . PHP_EOL
			. 'Created: ' . date( 'd.m.Y / H:i:s', $time)
			. PHP_EOL . PHP_EOL;
		foreach ($get_messages as $item) {
			$messages .= $item['name']
				. ' (' . functions::display_date($item['time']) . '): ' . PHP_EOL
				. bbcode::notags($item['message'])
				. PHP_EOL . PHP_EOL;
		}
		header('Content-Type: application/octet-stream');
		echo $messages;
	} else {
		jl_redirect();
	}
}