<?php

/**
 * Conference for JohnCMS
 * Wrapper for JohnCMS tables
 * @author Screamer
 * @copyright 2013
 */

class Model_Jlayer extends JL_Model {

	/**
	 * Get user data by nickname. If user is not exists, return empty array
	 * @param (string) $nickname Nickname
	 * @return (array)
	 */
	public function get_user($nickname) {
		$nickname = $this->db->escape_string($nickname);
		$result = $this->db->query("SELECT * FROM `users` WHERE `name` = '" . $nickname . "'");
		$data = $this->db->fetch_assoc($result);
		return is_array($data) ? $data : array();
	}

	/**
	 * Is user friend
	 * @param (int) $owner ID of owner of conference
	 * @param (int) $user ID of user for check
	 * @return (boolean)
	 */
 	public function is_friend($owner, $user) {
		return $this->db->result(
			"SELECT COUNT(*) FROM `cms_contact`"
			. " WHERE `user_id` = '" . intval($owner) . "'"
			. " AND `from_id` = '" . intval($user) . "'"
			. " AND `type` = '2'"
			. " AND `friends` = '1'"
			. " AND `ban` != '1'"
		) > 0;
	}

	/**
	 * Send system message to private
	 * @param (int) $user ID of user
	 * @param (string) $theme Theme of message
	 * @param (string) $message Message (You can use bb-codes in your message)
	 * @return (void)
	 */
	public function send_mail($user, $theme, $message) {
		$this->db->query(
			"INSERT INTO `cms_mail` SET "
			. "`user_id` = '0',"
			. "`from_id` = '" . intval($user) . "',"
			. "`text` = '" . $this->db->escape_string($message) . "',"
			. "`time` = '" . time() . "',"
			. "`sys` = '1',"
			. "`them` = '" . $this->db->escape_string($theme) . "'"
		);
	}

}