<?php

/**
 * Conference for JohnCMS
 * Private list handler
 * @author Screamer
 * @copyright 2013
 */

class Model_Private extends JL_Model {

	/**
	 * Add user to list
	 * @param (int) $cid ID of conference
	 * @param (int) $uid ID of user
	 * @return (void)
	 */
	public function add_user($cid, $uid) {
		$this->db->query("INSERT INTO `" . $this->table_prefix . "_private` SET `cid` = '" . intval($cid) . "', `uid` = '" . intval($uid) . "'");
	}

	/**
	 * Get list of users
	 * @param (int) $cid ID of conference
	 * @return (array)
	 */
	public function get_users($cid) {
		$private_table = "`" . $this->table_prefix . "_private`";
		$result = $this->db->query(
			"SELECT " . $private_table . ".*, `users`.* FROM " . $private_table
			. " LEFT JOIN `users` ON " . $private_table . ".`uid` = `users`.`id` "
			. " WHERE " . $private_table . ".`cid` = '" . intval($cid) . "'"
		);
		$list = array();
		while ($item = $this->db->fetch_assoc($result)) {
			$list[] = $item;
		}
		return $list;
	}

	/**
	 * Is user exists in private list of conference
	 * @param (int) $cid ID of conference
	 * @param (int) $uid ID of user
	 * @return (boolean)
	 */
	public function is_private($cid, $uid) {
		return $this->db->result(
			"SELECT COUNT(*) FROM `" . $this->table_prefix . "_private` "
			. "WHERE `cid` = '" . intval($cid) . "' AND `uid` = '" . intval($uid) . "'"
		) > 0;
	}

	/**
	 * Remove user from list
	 * @param (int) $cid ID of conference
	 * @param (int) $uid ID of user
	 */
	public function remove_user($cid, $uid = 0) {
		$cid = abs(intval($cid));
		$uid = abs(intval($uid));
		$this->db->query(
			"DELETE FROM `" . $this->table_prefix . "_private` "
			. "WHERE `cid` = '" . $cid . "' "
			. ($uid != 0 ? " AND `uid` = '" . $uid . "'" : "")
		);

	}

}