/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

import java.io.InputStream;
import java.io.InputStreamReader;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.midlet.*;

/**
 * @author meeks4
 */
public class Midlet extends MIDlet implements CommandListener {

    private Form form = null;
    private Command exit = new Command("", Command.EXIT, 1);
    private String page = "";
    private Display d = Display.getDisplay(this);
    private long time, bytes;
    private int len;
    private double kbps;

    public void startApp() {
        form = new Form("  !");
        form.append("...");
        form.addCommand(exit);
        form.setCommandListener(this);
        d.setCurrent(form);
        speed();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public void exitmidlet() {
        destroyApp(true);
        notifyDestroyed();
    }

    public void speed() {
        HttpConnection conn = null;
        InputStream is;
        InputStreamReader read;
        try {
            conn = (HttpConnection) Connector.open("http://johncms.com", Connector.READ_WRITE, true);
            time = System.currentTimeMillis();
            int c = conn.getResponseCode();
            if (c == HttpConnection.HTTP_OK) {
                is = conn.openInputStream();
                read = new InputStreamReader(is, "UTF-8");
                while (read.read() != -1) {
                    len++;
                }
            } else {
                page = " !";
            }
        } catch (Exception ex) {
            page = " !";
        } finally {
            try {
                if (conn != null) {
                    conn.close();
                }
                bytes = len / ((System.currentTimeMillis() - time) / 1000);
                kbps = bytes * 0.0078125;
            } catch (Exception ex) {
                page = " !";
            }
        }
        form.deleteAll();
        form.append(page + kbps + " / = " + (kbps / 8) + " /");
        form.addCommand(exit);
        form.setCommandListener(this);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == exit) {
            exitmidlet();
        }
    }
}
