<?php
namespace jl\wrappers\db {
	use jl\Db;
	use jl\exception\Exception;
	use jl\exception\InvalidArgumentException;

	/**
	 * JLayer
	 *
	 * MySQL Wrapper
	 *
	 * @package JohnCMS
	 * @subpackage JLayer
	 * @author Screamer
	 * @copyright 2013
	 */

	class Mysql extends Db {

		/**
		 * @var resource Link to connection
		 */
		protected $link;

		/**
		 * Create connection or existing
		 *
		 * @param string $host     Host
		 * @param string $user     User
		 * @param string $password Password
		 *
		 * @return \jl\wrappers\db\Mysql
		 */
		public function __construct($host, $user, $password) {
			$this->link = $this->connect($host, $user, $password);
		}

		/**
		 * Get number of affected rows in previous MySQL operation
		 *
		 * @return int
		 */
		public function affected_rows() {
			return mysql_affected_rows($this->link);
		}

		/**
		 * Returns the name of the character set
		 *
		 * @return string
		 */
		public function client_encoding() {
			return mysql_client_encoding($this->link);
		}

		/**
		 * Close MySQL connection
		 *
		 * @return boolean
		 */
		public function close() {
			return mysql_close($this->link);
		}

		/**
		 * Open a connection to a MySQL Server
		 *
		 * @param string $host         The MySQL server. It can also include a port number. e.g. "hostname:port" or a path to a local socket e.g. ":/path/to/socket" for the localhost.
		 * @param string $user         The username.
		 * @param string $password     The password.
		 * @param bool   $new_link     If a second call is made to mysql_connect() with the same arguments, no new link will be established, but instead, the link identifier of the already opened link will be returned.
		 * @param int    $client_flags The client_flags parameter can be a combination of the following constants: 128 (enable LOAD DATA LOCAL handling), MYSQL_CLIENT_SSL, MYSQL_CLIENT_COMPRESS, MYSQL_CLIENT_IGNORE_SPACE or MYSQL_CLIENT_INTERACTIVE.
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return resource|boolean
		 */
		public function connect($host, $user, $password, $new_link = false, $client_flags = 0) {
			if (!is_string($host)) {
				throw new InvalidArgumentException('host', 'string');
			}
			if (!is_string($user)) {
				throw new InvalidArgumentException('user', 'string');
			}
			if (!is_string($password)) {
				throw new InvalidArgumentException('password', 'string');
			}
			if (!is_bool($new_link)) {
				$new_link = (bool) $new_link;
			}
			if (!is_int($client_flags)) {
				$client_flags = 0;
			}

			return mysql_connect($host, $user, $password, $new_link, $client_flags);
		}

		/**
		 * Returns the numerical value of the error message from previous MySQL operation
		 *
		 * @return int
		 */
		public function errno() {
			return mysql_errno($this->link);
		}

		/**
		 * Returns the text of the error message from previous MySQL operation
		 *
		 * @return string
		 */
		public function error() {
			return mysql_error($this->link);
		}

		/**
		 * Escapes special characters in a string for use in an SQL statement
		 *
		 * @param string $string The string that is to be escaped.
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return string (string)
		 */
		public function escape_string($string) {
			if (!is_string($string)) {
				throw new InvalidArgumentException('string', 'string');
			}
			return mysql_real_escape_string($string, $this->link);
		}

		/**
		 * Fetch a result row as an associative array
		 *
		 * @param resource $result The result resource that is being evaluated. This result comes from a call to mysql_query().
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return array
		 */
		public function fetch_assoc($result) {
			if (!is_resource($result)) {
				throw new InvalidArgumentException('result', 'resource');
			}

			return mysql_fetch_assoc($result);
		}

		/**
		 * Fetch a result row as an object
		 *
		 * @param resource $result The result resource that is being evaluated.
		 * @param string   $class  The name of the class to instantiate, set the properties of and return. If not specified, a stdClass object is returned.
		 * @param array    $params An optional array of parameters to pass to the constructor for class_name objects.
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return object|boolean
		 */
		public function fetch_object($result, $class = 'stdClass', array $params = array()) {
			if (!is_resource($result)) {
				throw new InvalidArgumentException('result', 'resource');
			}
			if (!is_string($class)) {
				throw new InvalidArgumentException('class', 'string');
			}

			return mysql_fetch_object($result, $class, $params);
		}

		/**
		 * Get a result row as an enumerated array
		 *
		 * @param resource $result The result resource that is being evaluated.
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return array
		 */
		public function fetch_row($result) {
			if (!is_resource($result)) {
				throw new InvalidArgumentException('result', 'resource');
			}

			return mysql_fetch_row($result);
		}

		/**
		 * Free result memory
		 *
		 * @param resource $result The result resource that is being evaluated.
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return boolean
		 */
		public function free($result) {
			if (!is_resource($result)) {
				throw new InvalidArgumentException('result', 'resource');
			}

			return mysql_free_result($result);
		}

		/**
		 * Get the ID generated in the last query
		 *
		 * @return int
		 */
		public function insert_id() {
			return mysql_insert_id($this->link);
		}

		/**
		 * Get number of fields in result
		 *
		 * @param resource $result The result resource that is being evaluated.
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return int|boolean
		 */
		public function num_fields($result) {
			if (!is_resource($result)) {
				throw new InvalidArgumentException('result', 'resource');
			}
			return mysql_num_fields($result);
		}

		/**
		 * Get number of rows in result
		 *
		 * @param resource $result The result resource that is being evaluated.
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return int
		 */
		public function num_rows($result) {
			if (!is_resource($result)) {
				throw new InvalidArgumentException('result', 'resource');
			}

			return mysql_num_rows($result);
		}

		/**
		 * Send a MySQL query
		 *
		 * @param string $statement An SQL query. The query string should not end with a semicolon. Data inside the query should be properly escaped.
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return resource
		 */
		public function query($statement) {
			if (!is_string($statement)) {
				throw new InvalidArgumentException('statement', 'string');
			}

			$result = mysql_query($statement, $this->link);
			$error = $this->error();
			if ($error) {
				$this->jl_errors[] = array(
					$this->errno(),
					$this->error(),
					$statement
				);
			}
			return $result;
		}

		/**
		 * Get result data
		 *
		 * @param resource|string $result    An SQL query or Resource.
		 * @param int             $row       The row number from the result that's being retrieved. Row numbers start at 0.
		 * @param mixed           $field     The name or offset of the field being retrieved.
		 *
		 * @throws \jl\exception\Exception
		 * @throws \jl\exception\InvalidArgumentException
		 * @return string
		 */
		public function result($result, $row = 0, $field = 0) {
			if (!is_string($result) && !is_resource($result)) {
				throw new InvalidArgumentException('result', 'resource');
			}
			if (!is_int($row)) {
				throw new InvalidArgumentException('row', 'integer');
			}
			if (!is_int($field)) {
				throw new InvalidArgumentException('field', 'integer');
			}

			if (!is_resource($result)) {
				$result = $this->query($result);
			}
			if (!is_resource($result)) {
				throw new Exception('Invalid query');
			}
			return mysql_result($result, $row, $field);
		}

		/**
		 * Select a MySQL database
		 *
		 * @param string $name The name of the database that is to be selected.
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return boolean
		 */
		public function select_db($name) {
			if (!is_string($name)) {
			throw new InvalidArgumentException('name', 'string');
			}

			return mysql_select_db($name, $this->link);
		}

		/**
		 * Sets the client character set
		 *
		 * @param string $charset A valid character set name.
		 *
		 * @throws \jl\exception\InvalidArgumentException
		 * @return boolean
		 */
		public function set_charset($charset) {
			if (!is_string($charset)) {
				throw new InvalidArgumentException('charset', 'string');
			}

			return mysql_set_charset($charset, $this->link);
		}

	}
}