/**
 * Editable - jQuery plugin
 *
 * Author - Screamer <nwotnbm@gmail.com>
 *
 * Usage:
 *
 * $('document').ready(function () {
 *   $('#container').editable({
 *      url: "http://example.com/"
 *   });
 * });
 *
 * Options:
 * css_class - CSS Class for input field
 * input_field - Type of input field: textarea or input text
 * url - URL for ajax request (Method: POST; Params: type => %id_of_container% value => %value_of_field%)
 * type_field - Value of POST['type'] param. ID of container by default
 */

(function( $ ) {
    $.fn.editable = function(options) {
        var settings = $.extend(
            {
                css_class:   "editable",  // Class for input field
                input_field: "textarea",  // Type of input field: textarea or input text
                url:         "",          // URL for ajax request
                type_field:  ""           // Value of $_POST['type']
            }, options);
        if (settings.input_field != "textarea" && settings.input_field != "input") {
            settings.input_field = "textarea";
        }
        var editable = false;
        this.dblclick(function () {
            if (editable == false) {
                editable = true;
                var self = $(this);
                var send = true;
                var text_container = self.find('div');
                text_container.css({display: "none"});
                var text = text_container.text();
                var form = jQuery('<form />').attr('method', 'post');
                form.attr('class', settings.css_class);
                var input_field = jQuery('<' + settings.input_field + ' />').val(text);
                if (settings.input_field == 'input') {
                    input_field.attr('type', 'text');
                }
                form.append(input_field);
                self.append(form);
                input_field.focus();
                input_field.keydown(function(e) {
                    if (e.keyCode == 27) { // Discard changes on Escape
                        send = false;
                        e.preventDefault();
                        input_field.blur();
                    } else if (e.keyCode == 13 && e.ctrlKey) { // Save on Ctr+Enter
                        e.preventDefault();
                        form.submit();
                        input_field.blur();
                    }
                });
                input_field.blur(function(e) {
                    e.preventDefault();
                    if (send) {
                        form.submit();
                    }
                    text_container.css({display: "block"});
                    form.css({display: "none"});
                    editable = false;
                });
                form.submit(function (e) {
                    if (settings.type_field.length == 0) {
                        settings.type_field = self.attr('id');
                    }
                    e.preventDefault();
                    $.ajax({
                        type:     "POST",
                        data:     {
                            "type": settings.type_field,
                            "value": input_field.val()
                        },
                        dataType: "html",
                        url:      settings.url,
                        success:  function (result) {
                            text_container.html(result);
                        }
                    });
                });
            }
        });
        return this;
    };
})(jQuery);
