#!/bin/sh

# Author: Kyle Baker (kyleabaker)
# Web: http://www.kyleabaker.com/

# This script was based on the tutorial by Marius Nestor
# http://news.softpedia.com/news/How-to-Fix-the-Big-and-Ugly-Plymouth-Logo-in-Ubuntu-10-04-140810.shtml

# Step 1
sudo apt-get install v86d -y

# Step 2
# Replace:
# -: GRUB_CMDLINE_LINUX_DEFAULT="quiet splash"
# +: GRUB_CMDLINE_LINUX_DEFAULT="quiet splash nomodeset video=uvesafb:mode_option=1280x1024-24,mtrr=3,scroll=ywrap"
sed 's/GRUB\_CMDLINE\_LINUX\_DEFAULT\=\"quiet\ splash\"/GRUB\_CMDLINE\_LINUX\_DEFAULT\=\"quiet\ splash\ nomodeset\ video\=uvesafb\:mode\_option\=1280x1024-24\,mtrr\=3\,scroll\=ywrap\"/g' /etc/default/grub > ./temp
sudo mv -f ./temp /etc/default/grub

# Replace:
# -: #GRUB_GFXMODE=640x480
# +: GRUB_GFXMODE=1280x1024
sed 's/\#GRUB\_GFXMODE\=640x480/GRUB\_GFXMODE\=1280x1024/g' /etc/default/grub > ./temp
sudo mv -f ./temp /etc/default/grub

# Step 3
sudo echo "uvesafb mode_option=1280x1024-24 mtrr=3 scroll=ywrap" >> /etc/initramfs-tools/modules

# Step 4
echo FRAMEBUFFER=y | sudo tee /etc/initramfs-tools/conf.d/splash

# Step 5
sudo update-grub2

# Step 6
sudo update-initramfs -u

# Step 7
echo "     Complete, reboot to test changes!"
