<?php
/**
 * KoeNysqli
 *
 * Обертка для Mysqli
 *
 * @author Koenig <http://johncms.com/users/profile.php?user=6565>
 * @version 1.3
 */
class KoeMysql extends Mysqli

{
  /**
   * limit
   *
   * @var integer or array
   */
  private $limit = false;
  /**
   * условия
   *
   * @var array
   */
  private $where = array();
  /**
   * условия сортировки
   *
   * @var array
   */
  private $sort = array();
  /**
   * Группировка по полю
   *
   * @var array
   */
  private $group = array();
  /**
   * constructor
   *
   * @param string $db_host
   * @param string $db_user
   * @param string $db_pass
   * @param string $db_name
   * @param string $db_charset
   * @param integer $port
   * @return mysqli_stmt
   */
  public function __construct($db_host, $db_user, $db_pass, $db_name, $db_charset, $port = 3306)
  {
    @parent::__construct($db_host, $db_user, $db_pass, $db_name, $port);
    @$this->set_charset($db_charset);
    if ($this->connect_errno) die($this->connect_error);
  }
  /**
   * stmt count params => ?
   *
   * @return integer
   */
  public function count_params()
  {
    return $this->stmt ? $this->stmt->param_count : die('stmt not started');
  }
  /**
   * stmt count fields in result
   *
   * @param void
   * @return integer
   */
  public function count_fields()
  {
    return $this->stmt ? $this->stmt->field_count : die('stmt not started');
  }
  /**
   * return yes/no fetch result
   *
   * @param void
   * @return boolean
   */
  public function is_fetch()
  {
    if ($this->stmt) {
      return preg_match('/select/i', $this->sql) ? true : false;
    }
    else {
      die('Query not execute');
    }
  }
  /**
   * sql
   *
   * @param string $sql
   * @return mysqli_stmt
   */
  public function sql($sql)
  {
    $this->sql = $sql;
    return $this;
  }
  /**
   * result
   *
   * @param mixed $placeholders
   * @return array|integer|boolean
   */
  public function result($placeholders = null)
  {
    $this->sql .= $this->get_where() . $this->get_group() . $this->get_sort() . $this->get_limit();
    if (!$this->stmt = $this->prepare($this->sql)) {
      die('error sql <<< ' . $this->sql . ' >>>');
    }
    if ($this->count_params() && $placeholders) {
      if (!$this->set_placeholders($placeholders)) {
        die('Placeholders failed');
      }
    }
    if (!$this->is_fetch()) {
      $this->stmt->execute();
      return $this->stmt->affected_rows;
    }
    else {
      $this->stmt->execute();
      if (!$this->bind_result()) {
        die('Bind result failed');
      }
    }
    $this->limit = false;
    $this->sort = array();
    $this->where = array();
    return $this->fetch_result();
  }
  /**
   * autofetch
   *
   * @param void
   * @return array|integer|boolean
   */
  public function fetch_result()
  {
    if (!$this->stmt->num_rows) {
      $return = false;
    }
    if ($this->count_fields() == 1) {
      $res = $this->stmt->get_result();
      $row = $res->fetch_row();
      $return = $row[0];
    }
    else {
      $return = array();
      $res = $this->stmt->get_result();
      while ($row = $res->fetch_assoc()) {
        array_push($return, $row);
      }
    }
    return $return;
  }
  /**
   * bind result for placeholders
   * @param void
   * @return mysqli_stmt
   */
  public function bind_result()
  {
    $result = array();
    $binds = array();
    $meta = $this->stmt->result_metadata();
    while ($field = $meta->fetch_field()) {
      $binds[] = & $row[$field->name];
    }
    if (!call_user_func_array(array(
      $this->stmt,
      'bind_result'
    ) , $binds)) {
      die('Not bind result');
    }
    return $this->stmt;
  }
  /**
   * set placeholders
   *
   * @param array $args
   * @return mysqli_stmt
   */
  public function set_placeholders($args)
  {
    if (!is_array($args)) {
      $args = array(
        $args
      );
    }
    $types = '';
    $newarray = array();
    for ($i = 0; $i < sizeof($args); $i++) {
      $types .= is_numeric($args[$i]) ? 'i' : ((is_double($args[$i]) || is_float($args[$i])) ? 'd' : 's');
      $newarray[] = $args[$i];
    }
    $args = array();
    $args[] = $types;
    foreach($newarray as $k => $v) {
      $args[] = & $newarray[$k];
    }
    if (!call_user_func_array(array(
      $this->stmt,
      'bind_param'
    ) , $args)) {
      die('Not bind params');
    }
    return $this->stmt;
  }
  public function orwhere($array)
  {
    $str = '(';
    $array = is_array($array) && sizeof($array) > 0 ? $array : die('invalid arguments in orwhere');
    $i = sizeof($array);
    $x = 1;
    foreach($array as $args) {
      list($field, $type, $value) = $args;
      $str .= $this->where($field, $type, $value, 1);
      if ($x != $i) {
        $str .= ' OR ';
      }
      else {
        $str .= ') ';
      }
      $x++;
    }
    array_unshift($this->where, $str);
    return $this;
  }
  /**
   * add where
   *
   * @param string $field
   * @param string $type
   * @param string $value
   */
  public function where($field, $type, $value, $or = false)
  {
    $str = in_array($type, array(
      '=',
      '!=',
      '>',
      '<',
      '<=',
      '>=',
      'like',
      'regexp'
    )) ? '`' . $field . '`' . $type . (is_int($value) ? $value : ($value == '?' ? $value : ($type == 'like' ? "'%" . $value . "%'" : "'" . $value . "'"))) : die('invalid argument in where');
    if ($type == 'in') {
      $str = 'in(';
      $value = is_array($value) && sizeof($value) > 0 ? $value : die('invalid arguments in where');
      $i = sizeof($value);
      $x = 1;
      foreach($value as $val) {
        $str .= is_int($val) || $val == '?' ? $val : "'" . $value . "'";
        if ($x != $i) {
          $str .= ', ';
        }
        else {
          $str .= ' ';
        }
        $x++;
      }
      $str .= ')';
    }
    if (!$or) {
      $this->where[] = $str;
      return $this;
    }
    else {
      return $str;
    }
  }
  /**
   * set limits
   *
   * @param array or integer $args
   @return mysqli_stmt
   */
  public function limit($args)
  {
    if (is_array($args) && sizeof($args) == 2) {
      $str = ' LIMIT ' . implode(' ,', array_values($args));
    }
    elseif (is_int($args)) {
      $str = ' LIMIT ' . $args;
    }
    else {
      die('Number of arguments 1 (string) or 2 (array)');
    }
    $this->limit = $str;
    return $this;
  }
  /**
   * set sort params
   *
   * @param array $args
   * @return mysqli_stmt
   */
  public function order($field, $type)
  {
    $type = in_array(mb_strtolower($type) , array(
      'asc',
      'desc'
    )) ? $type : die('invalid arguments in order');
    $this->sort[] = '`' . $field . '` ' . mb_strtoupper($type);
    return $this;
  }
  /**
   * group by field
   *
   * @param string $field
   * @return mysqli_stmt
   */
  public function group($field)
  {
    $this->group[] = $field;
    return $this;
  }
  /**
   * get group
   *
   * @param void
   */
  public function get_group()
  {
    $this->sql .= sizeof($this->group) > 0 ? ' GROUP BY ' . implode(' ,', array_values($this->group)) : '';
  }
  /**
   * get sort
   *
   * @param void
   */
  public function get_sort()
  {
    $this->sql .= ' ORDER BY ' . implode(' ,', array_values($this->sort));
  }
  /**
   * get limit
   *
   * @param void
   */
  public function get_limit()
  {
    $this->sql .= $this->limit;
  }
  /**
   * get where
   *
   * @param void
   */
  public function get_where()
  {
    $this->sql .= sizeof($this->where) > 0 ? ' WHERE ' . implode(' AND ', array_values($this->where)) : '';
  }
}    
?>