<?php

ini_set('display_errors', 'On');
error_reporting(E_ALL & ~E_NOTICE);

class md5Decrypt
{
    // Хэш мд5
    private $hash;

    // Результаты поиска
    public  $result = array();

    // Искать ли на всех сайтах
    private $fullSearch = false;

    // Конструируем объект
    function __construct($hash, $fullSearch = false)
    {
        $this->fullSearch = $fullSearch;
        $this->hash = trim($hash);
        set_time_limit(120);
    }

    // Получаем хеш из Баз
    public function decrypt()
    {
        // Прогонка по базам
        $this->baseLOCAL();         // Локальный кеш первым
        $this->baseRainbow();
        $this->baseMD5HASH();
        $this->baseDECODER();
        $this->baseLIST();
        $this->baseNOISETTE();
        $this->baseGromweb();
        $this->baseDARKBYTE();
        $this->baseMD5DECRIPTION();
        $this->baseMD5CRACK();
        $this->baseMMKEY();
        $this->baseMD5ONLINE();
        $this->baseONLINEHASHCRACK();
    }

    // Получает контент
    private function getResponse($url, $POSTquery = '')
    {
        if (!($ch = curl_init($url)))
        {
            $context = stream_context_create(array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-Type: application/x-www-form-urlencoded' . PHP_EOL,
                    'content' => $POSTquery,
                ),
            ));
            $response = file_get_contents($url, false, $context);
            return $response;
        }

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows; U; Windows NT 5.1; ru; rv:1.9.0.8) Gecko/2009032609 Firefox/3.0.8");
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $POSTquery);
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }

    // Парсеры разных баз
    private function baseGromweb()
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = $this->getResponse('http://md5.gromweb.com/?md5=' . $this->hash);
        preg_match('/name="string" value="(.+?)"/i', $response, $matches);
        if ($matches[1] && $matches[1] != '" id=')
            $this->result += array('md5.gromweb.com: <b>' . $matches[1] . '</b>');
    }

    private function baseRainbow()
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = $this->getResponse('http://www.md5rainbow.com/' . $this->hash);
        preg_match('/(.+?)<br\/><p style="font-size: 9pt;/i', $response, $matches);
        if ($matches[1])
            $this->result += array('md5rainbow.com: <b>' . $matches[1] . '</b>');
    }

    private function baseMD5HASH()
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = $this->getResponse('http://www.md5-hash.com/md5-hashing-decrypt/' . $this->hash);
        preg_match('/<strong class="result">(.+?)<\/strong>/i', $response, $matches);
        if ($matches[1])
            $this->result += array('md5-hash.com: <b>' . $matches[1] . '</b>');
    }

    private function baseDECODER()
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = $this->getResponse('http://md5decoder.com/' . $this->hash . '/');
        preg_match('/r>(.+?)</i', $response, $matches);
        if ($matches[1] && !strstr($matches[1], 'type="text/javascript'))
            $this->result += array('md5decoder.com: <b>' . $matches[1] . '</b>');
    }

    private function baseNOISETTE()
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = $this->getResponse('http://md5.noisette.ch/?hash=' . $this->hash);
        preg_match('/name="text" value="(.+?)"/i', $response, $matches);
        if ($matches[1])
            $this->result += array('md5.noisette.ch: <b>' . $matches[1] . '</b>');
    }

    private function baseLIST()
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = $this->getResponse('http://md5list.ru/?pass=&md5='.$this->hash.'&md5_button=%D0%E0%F1%F8%E8%F4%F0%EE%E2%E0%F2%FC');
        preg_match('/09af30">Пароль: (.+?)<\//i', $response, $matches);
        if ($matches[1])
            $this->result += array('md5list.ru: <b>' . $matches[1] . '</b>');
    }

    private function baseDARKBYTE()
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = $this->getResponse('http://md5.darkbyte.ru/ncode.php?q='.$this->hash.'&r=1');

        if ($response)
            $this->result += array('md5.darkbyte.ru: <b>' . $response . '</b>');
    }

    private function baseMD5DECRIPTION()
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = $this->getResponse('http://md5decryption.com/', 'hash=' . $this->hash . '&submit='.urlencode('Decrypt It!'));
        preg_match('/Text: <\/b>(.+?)<\//i', $response, $matches);
        if ($matches[1])
            $this->result += array('md5decryption.com: <b>' . $matches[1] . '</b>');
    }

    private function baseMD5CRACK()
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = $this->getResponse('http://www.md5crack.com/home', 'list=' . $this->hash . '&crack='. urlencode('Crack Hashes'));
        preg_match('/<\/strong>: (.+?)<\/p>/i', $response, $matches);
        if ($matches[1] && $matches[1] != 'Unable to crack.')
            $this->result += array('md5crack.com: <b>' . $matches[1] . '</b>');
    }

    private function baseMMKEY()
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = $this->getResponse('http://www.mmkey.com/md5/', 'md5=' . $this->hash . '&sha256=&lx=chkmysql&chkmd5=');
        preg_match('/'.$this->hash.'.+?:(.+?) <\/font>/i', $response, $matches);
        if ($matches[1])
            $this->result += array('mmkey.com: <b>' . $matches[1] . '</b>');
    }

    private function baseMD5ONLINE()
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = $this->getResponse('http://www.md5online.org/', 'md5=' . $this->hash . '&search=0&action=decrypt&a=' . mt_rand(10000000,99999999));
        preg_match('/Found : <b>(.+?)<\/b>/i', $response, $matches);
        if ($matches[1])
            $this->result += array('md5online.org: <b>' . $matches[1] . '</b>');
    }

    private function baseONLINEHASHCRACK()
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = $this->getResponse('http://www.onlinehashcrack.com/multi-hash-cracking.php', 'hashVIP=' . $this->hash . '&emailVIP=notify@spam.su&submitVIP='.urlencode('Send it'));
        preg_match('/Plain text.+?>(.+?)<\/b>/i', $response, $matches);
        if ($matches[1])
            $this->result += array('onlinehashcrack.com: <b>' . $matches[1] . '</b>');
    }

    function baseAUTHSECU() // TEST
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = $this->getResponse('http://authsecu.com/decrypter-dechiffrer-cracker-hash-md5/script-hash-md5.php', 'valeur_bouton=dechiffrage&champ1=cdefce4be400c2807d735afdb9b81ff9&champ2=' . $this->hash . '&dechiffrer.x=29&dechiffrer.y=4');
        preg_match_all('/Chaîne correspondante.+?">(.+?)<\/p><\/td>/mi', $response, $matches);
        return $matches;
        if ($matches[1])
            $this->result += array('authsecu.com: <b>' . $matches[1] . '</b>');
    }

    private function baseLOCAL()
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = parse_ini_file('base.ini');
        if ($response[$this->hash])
            $this->result += array($_SERVER['HTTP_HOST'] . ': <b>' . base64_decode(str_replace('+', '=', $response[$this->hash])) . '</b>');
    }
}

if (isset($_GET['val']))
{
    switch ($_GET['operation'])
    {
        // Шифровка
        case 'encrypt':
            $hash = md5($_GET['val']);
            $value = base64_encode($_GET['val']);
            echo $hash;
            // Кешируем локально
            $baseFile = file_get_contents('base.ini');
            $base = parse_ini_string($baseFile);
            if (!$base[$hash])
                file_put_contents('base.ini', $baseFile . PHP_EOL . $hash . '=' . str_replace('=', '+', $value));
            die;
            break;

        // Расшифровка
        default:
            if (strlen($_GET['val']) != 32)
                die('Не правильный хеш');

            $decrypt = new md5Decrypt($_GET['val']);
            $decrypt->decrypt();
            if (reset($decrypt->result))
                echo reset($decrypt->result);
            else
                echo 'Не найдено';
            die;
    }
}