#CharsetDisable on

AddDefaultCharset UTF-8
RewriteEngine On
Options -Indexes +FollowSymlinks
#Options -Indexes +FollowSymlinks -MultiViews
#RewriteBase /

RewriteRule ^([0-9]+)/*$ ./index.php?id=$1 [QSA,NC]
RewriteRule ^([0-9]+)/([0-9]+)/*$ ./index.php?id=$1&page=$2 [QSA,NC]

RewriteRule ^view_comments/([0-9]+)/*([0-9]*)/*$ ./view_comments.php?id=$1&page=$2 [QSA,NC]
RewriteRule ^view/([0-9]+)/*$ ./view.php?id=$1 [QSA,NC]

RewriteRule ^news_comments/([0-9]+)/*([0-9]*)/*$ ./news_comments.php?id=$1&page=$2 [QSA,NC]
RewriteRule ^news/*([0-9]*)/*$ ./news.php?page=$1 [QSA,NC]

RewriteRule ^ffmpeg/([0-9]+)/*$ ./ffmpeg.php?id=$1 [QSA,NC]
RewriteRule ^apic/([0-9]+)/*$ ./apic.php?id=$1 [QSA,NC]
RewriteRule ^email/([0-9]+)/*$ ./email.php?id=$1 [QSA,NC]
RewriteRule ^abuse/([0-9]+)/*$ ./abuse.php?id=$1 [QSA,NC]
RewriteRule ^im/([0-9]+)/*$ ./im.php?id=$1 [QSA,NC]
RewriteRule ^theme/([0-9]+)/*$ ./theme.php?id=$1 [QSA,NC]
RewriteRule ^load/([0-9]+)/*$ ./load.php?id=$1 [QSA,NC]
RewriteRule ^settings/([0-9]+)/*$ ./settings.php?id=$1 [QSA,NC]
RewriteRule ^stat/([0-9]+)/*$ ./stat.php?id=$1 [QSA,NC]
RewriteRule ^table/([0-9]+)/*$ ./table.php?id=$1 [QSA,NC]
RewriteRule ^exchanger/([0-9]+)/*$ ./exchanger.php?id=$1 [QSA,NC]
RewriteRule ^rate/([0-9]+)/*$ ./rate.php?i=$1 [QSA,NC]
RewriteRule ^cut/([0-9]+)/*$ ./cut.php?id=$1 [QSA,NC]
RewriteRule ^txt_zip/([0-9]+)/*$ ./txt_zip.php?id=$1 [QSA,NC]
RewriteRule ^txt_jar/([0-9]+)/*$ ./txt_jar.php?id=$1 [QSA,NC]
RewriteRule ^jad/([0-9]+)/*$ ./jad.php?id=$1 [QSA,NC]

RewriteRule ^search/*([0-9]*)/*$ ./search.php?page=$1 [QSA,NC]
RewriteRule ^top/*([0-9]*)/*$ ./top.php?page=$1 [QSA,NC]
RewriteRule ^new/*([0-9]*)/*$ ./new.php?page=$1 [QSA,NC]

RewriteRule ^service/*$ ./service.php [QSA,NC]


RewriteRule ^zip/([0-9]+)/*([0-9]*)/*$ ./zip.php?id=$1&page=$2 [QSA,NC]
RewriteRule ^zip/preview/([0-9]+)/(.+)/([0-9]*)/*$ ./zip.php?action=preview&id=$1&name=$2&page=$3 [QSA,NC]
RewriteRule ^zip/down/([0-9]+)/(.+)/*$ ./zip.php?action=down&id=$1&name=$2 [QSA,NC]


RewriteRule ^read/([0-9]+)/*([0-9]*)/*$ ./read.php?id=$1&page=$2 [QSA,NC]


<Files ~ "\.dat$|\.htaccess$|\.htpasswd$|\.log$|\.cfg$|\.conf$|\.inc$|\.ini$">
    Order allow,deny
    Deny from All
    Satisfy All
</Files>


<Limit GET POST>
    Order allow,deny
    Allow from all
</Limit>

DirectoryIndex index.php

# PHP
#AddHandler application/x-httpd-php .php .phtml

AddType text/vnd.wap.wml .wml
AddType text/vnd.wap.wmlscript .wmls
AddType text/vnd.wap.si .si
AddType text/vnd.wap.sl .sl
AddType text/vnd.sun.j2me.app-descriptor .jad
AddType text/vnd.sun.j2me.app-descriptor .db
AddType text/x-vcard .vcf
AddType text/x-vcalendar .vcs
AddType text/x-vmel .mel
AddType text/x-vmel .emy
AddType text/x-co-desc .cod
AddType text/x-emelody .emy
AddType text/calendar .ics
AddType text/x-imelody .imy
AddType text/plain .txt
AddType text/plain .dat
AddType text/xml .xml
AddType text/css .css
AddType text/javascript .js

AddType application/vnd.android.package-archive .apk
AddType application/java-archive .jar
AddType application/vnd.wap.wmlc .wmlc
AddType application/vnd.wap.wmlscriptc .wmlsc
AddType application/vnd.wap.slc .slc
AddType application/vnd.wap.sic .sic
AddType application/octet-stream .tsk
AddType application/vnd.eri.thm .thm
AddType application/vnd.nok-s40theme .nth
AddType application/vnd.Nokie.ringing-tone .rng
AddType application/vnd.nokia.gamedata .nqd
AddType application/x-nokiagamedata .ngd
AddType application/vnd.alcatel.SEQ .seq
AddType application/vnd.uiq.thm .utz
AddType application/vnd.mophun.application .mpn
AddType application/vnd.mophun.certificate .mpc
AddType application/vnd.sonyericsson.mms-template tpl
AddType application/vnd.siemens-mp.theme .sdt
AddType application/vnd.siemens-mp.skin .scs
AddType application/vnd.siemens-mp.t9db .ldb
AddType application/vnd.ms-cab-compressed .cab
AddType application/vnd.symbian.install .sis
AddType application/octet-stream .sisx
AddType application/vnd.symbian.install .app
#AddType application/x-httpd-php .rss
AddType application/x-shockwave-flash .swf
AddType application/x-compress .z
AddType application/x-7z-compressed .7z
AddType application/x-rar-compressed .rar
AddType application/x-zip .zip
AddType application/x-gzip .gz
AddType application/x-gzip .tgz
AddType application/x-tar .tar
AddType application/x-bzip .bz
AddType application/x-bzip .bz2
AddType application/x-tar .hid
AddType application/x-pmd .pmd
AddType application/x-dvi .dvi
AddType application/x-tex .tex
AddType application/chm .chm
AddType application/smil .smil
AddType application/smil .smi
AddType application/vnd.smaf .mmf
AddType application/vnd .smaf
AddType application/vnd.wap.mms-message .mms
AddType application/vnd.oma.drm.message .dm
AddType application/msword .doc
AddType application/pdf .pdf
AddType application/postscript .ps
AddType application/postscript .eps
AddType application/octet-stream .com
AddType application/octet-stream .exe
AddType application/octet-stream .bat

AddType audio/basic .au
AddType audio/basic .snd
AddType audio/imelody .imy
AddType audio/mid .srt
AddType audio/mid .midi
AddType audio/mid .mid
AddType audio/mid .col
AddType audio/mpeg .mp3
AddType audio/aac .aac
AddType audio/amr .amr
AddType audio/amr-wb .awb
AddType audio/rmf .rmf
AddType audio/vnd.qcelp .qcp
AddType audio/aiff .aiff
AddType audio/x-wav .wav
AddType audio/x-ms-wma .wma
AddType audio/ogg .ogg
AddType audio/flac .flac

AddType image/vnd.wap.wbmp .wbmp
AddType image/bmp .bmx
AddType image/png .png
AddType image/jpeg .jpg
AddType image/jpeg .jpe
AddType image/jpeg .jpeg
AddType image/gif .gif
AddType image/bmp .bmp
AddType image/x-epoc-mbm .mbm
AddType image/vnd.nok-3dscreensaver .n3a
AddType image/x-epoc-mbm .mbm
AddType image/vnd.nok-3dscreensaver .n3a
AddType image/vnd.nok-oplogo-colornokia-op-logo .nok
AddType image/x-jg .art
AddType image/tiff .tiff

AddType video/3gpp .3gp
AddType video/mp4 .mp4
AddType video/mpeg .mpeg
AddType video/mpeg .mpg
AddType video/mpeg .mpe
AddType video/quicktime .mov
AddType video/quicktime .qt
AddType video/x-msvideo .avi
AddType video/x-ms-wmv .wmv
AddType video/x-ms-asf .asf
AddType video/x-ivf .ivf
AddType video/x-flv .flv
AddType video/webm .webm

AddType x-world/x-vrml .wrl


# Кодировка
php_value default_charset UTF-8

# максимальный размер файлов для аплоада
php_value upload_max_filesize 999M
php_value post_max_size 999M

# временная зона
php_value date.timezone "Europe/Moscow"

# MIME тип по умолчанию
php_value default_mimetype text/html

# магические кавычки
php_flag magic_quotes_gpc Off
php_flag magic_quotes_runtime Off
php_flag magic_quotes_sybase Off

# Не создаются переменные argc и argv
php_flag register_argc_argv Off

# Глобальные переменные!
php_flag register_globals Off


#Отладка
php_flag display_errors Off
php_value error_reporting -1
php_flag log_errors On
php_value error_log /error_log


# Компрессия
#php_value zlib.output_compression 4096
#php_value zlib.output_compression_level 6

<IfModule mod_deflate.c>
    AddOutputFilterByType DEFLATE text/css application/javascript text/html application/xhtml+xml application/xml text/xml application/rss+xml text/vnd.wap.wml text/plain
    <IfModule mod_setenvif.c>
        BrowserMatch ^Mozilla/4 gzip-only-text/html
        BrowserMatch ^Mozilla/4\.0[678] no-gzip
        BrowserMatch \bMSIE !no-gzip !gzip-only-text/html
    </IfModule>
</IfModule>

<IfModule mod_expires.c>
    ExpiresActive On
    ExpiresByType image/gif "access plus 2 months"
    ExpiresByType image/jpeg "access plus 2 months"
    ExpiresByType image/png "access plus 2 months"
    ExpiresByType text/css "access plus 2 months"
    ExpiresByType application/javascript "access plus 2 months"
    ExpiresByType image/vnd.microsoft.icon "access plus 2 months"
</IfModule>


#ErrorDocument 304 /?
#ErrorDocument 400 /?
ErrorDocument 404 /?
#ErrorDocument 406 /?
#ErrorDocument 500 /?
#ErrorDocument 502 /?