<?php

class Kzip {
    
private $zip;
   
public function __construct($archive) {
if (!extension_loaded('zip')) {
die('Unsupported Ziparchive class');
} 
$this->zip = new ZipArchive();
if (file_exists($archive)) {
$this->zip->open($archive) === true;    
} else {
$this->zip->open($archive, ZipArchive::CREATE) === true;        
}
}

public function extractTo($dir) {
$array = $this->getNames();
foreach ($array['cp'] as $k => $file) {    
$str = $this->zip->getFromName($file);
$pos = strrpos($array['utf'][$k], DIRECTORY_SEPARATOR);
$ee =  str_split($array['utf'][$k], $pos + 1);
if(!is_dir($dir . $ee[0])) {
mkdir($dir . $ee[0], 0777, true);
}
file_put_contents($dir . $array['utf'][$k], $str);
}
}

public function getNames() {
$names = array();    
for ($i = 0; $i < $this->zip->numFiles; $i++) {
$names['utf'][] = $this->fineName($this->zip->getNameIndex($i), 1);
$names['cp'][] = $this->zip->getNameIndex($i);
}
return $names;    
}

public function addFromDirecory($dir) {
$all = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir, FilesystemIterator::SKIP_DOTS), RecursiveIteratorIterator::CHILD_FIRST);
$files = array();
foreach ($all as $list) {
if ($list->isFile()) {
$files[] = $list->getPathname();  
}
}
foreach ($files as $file) {
$this->zip->addFile($file, $this->fineName($file));    
}
}

public function fineName($path, $mode = 0) {
return (!$mode) ? iconv('UTF-8', 'CP866//TRANSLIT//IGNORE', $path) : iconv('CP866', 'UTF-8//TRANSLIT//IGNORE', $path);
}

public function close() {
$this->zip->close();
}

}
?>