<?php
/**
* Kzip
*
* Обертка для ZipArchive
*
* @author Koenig <http://johncms.com/users/profile.php?user=6565>
* @version 0.2
*/ 

class Kzip
{
  /**
  * :)
  * 
  * @var ZipArchive
  */
  private $zip;
  /**
  * constructor
  * 
  * @param mixed $archive
  * @return Kzip
  */
  public function __construct($archive)
  {
    if (!extension_loaded('zip')) {
      die('Unsupported Ziparchive class');
    }
    $this->zip = new ZipArchive();
    if (file_exists($archive)) {
      $this->zip->open($archive);
    }
    else {
      $this->zip->open($archive, ZipArchive::CREATE);
    }
  }
  /**
  * extract from directory
  * 
  * @param mixed $dir
  */
  public function extractTo($dir)
  {
    $array = $this->getNames();
    foreach($array['cp'] as $k => $file) {
      $str = $this->zip->getFromName($file);
      $pos = strrpos($array['utf'][$k], DIRECTORY_SEPARATOR);
      $ee = str_split($array['utf'][$k], $pos + 1);
      if (!is_dir($dir . $ee[0])) {
        mkdir($dir . $ee[0], 0777, true);
      }
      file_put_contents($dir . $array['utf'][$k], $str);
    }
  }
  /**
  * get array names of files
  * @param void
  * @return array
  */
  public function getNames()
  {
    $names = array();
    for ($i = 0; $i < $this->zip->numFiles; $i++) {
      $names['utf'][] = $this->fineName($this->zip->getNameIndex($i) , 1);
      $names['cp'][] = $this->zip->getNameIndex($i);
    }
    return $names;
  }
  /**
  * put zip archive directory
  * 
  * @param mixed $dir
  */
  public function addFromDirecory($dir)
  {
    foreach(new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir, FilesystemIterator::SKIP_DOTS) , RecursiveIteratorIterator::CHILD_FIRST) as $list) {
      if ($list->isFile()) {
        $this->zip->addFile($list->getPathname() , $this->fineName($list->getPathname()));
      }
    }
  }
  /**
  * put your comment there...
  * 
  * @param mixed $path
  * @param int $mode
  * @return mixed
  */
  public function fineName($path, $mode = 0)
  {
    return (!$mode) ? iconv('UTF-8', 'CP866//TRANSLIT//IGNORE', $path) : iconv('CP866', 'UTF-8//TRANSLIT//IGNORE', $path);
  }
  /**
  * destructor
  * @param void
  * 
  */
  public function close()
  {
    $this->zip->close();
  }
}
?>