<?php
class KSwitcher {
private $switchTypes;
private $switchStyles;
private $autodetect = 0; // 0 -> off | 1 -> on | 2 -> user select

public function __construct() {
$this->setTypeNames();
$this->setStyleNames();
$this->check();
$this->render();
}

public function head() {
$defaultuphead = 'theme/' . $this->getType() . '/default/incfiles/uphead.php';
$uphead = file_exists('theme/' . $this->getType() . '/' . $this->getStyle() . '/incfiles/uphead.php') ? 'theme/' . $this->getType() . '/' . $this->getStyle() . '/incfiles/uphead.php' : $defaultuphead;

$defaultdownhead = 'theme/' . $this->getType() . '/default/incfiles/downhead.php';
$downhead = file_exists('theme/' . $this->getType() . '/' . $this->getStyle() . '/incfiles/downhead.php') ? 'theme/' . $this->getType() . '/' . $this->getStyle() . '/incfiles/downhead.php' : $defaultdownhead;

require_once($uphead);
$css = glob('theme/' . $this->getType() . '/' . $this->getStyle() . '/css/*.css');
if (sizeof($css) > 0) {
foreach ($css as $style) {
echo PHP_EOL . '<link rel="stylesheet" href="' . $style . '" type="text/css" media="screen" />' . PHP_EOL;
}
}
$js = glob('theme/' . $this->getType() . '/' . $this->getStyle() . '/js/*.js');
if (sizeof($js) > 0) {
foreach ($js as $script) {
echo PHP_EOL . '<script type="text/javascript" src="' . $script . '"></script>' . PHP_EOL;
}
}
require_once($downhead);
}

public function end() {
$default = 'theme/' . $this->getType() . '/default/incfiles/end.php';
$end = file_exists('theme/' . $this->getType() . '/' . $this->getStyle() . '/incfiles/end.php') ? 'theme/' . $this->getType() . '/' . $this->getStyle() . '/incfiles/end.php' : $default;
require_once($end);
}

public function main() {
$default = 'theme/' . $this->getType() . '/default/incfiles/main.php';
$main = file_exists('theme/' . $this->getType() . '/' . $this->getStyle() . '/incfiles/main.php') ? 'theme/' . $this->getType() . '/' . $this->getStyle() . '/incfiles/main.php' : $default;
require_once($main);
}

public function render() {
$this->head();

echo $this->viewSwitchType();
echo $this->viewSwitchStyle();

$this->main();

$this->end();
}

public function getTypeNames() {
return $this->switchTypes;
}

public function setTypeNames() {
$this->switchTypes = array_map(array($this, 'getElement'), glob('theme/*'));
}

public function getStyleNames() {
return $this->switchStyles;
}

public function setStyleNames() {
$this->switchStyles = array_map(array($this, 'getElement'), array_diff(glob('theme/' . $this->getType() . '/*'), array('theme/' . $this->getType() . '/default')));
}

public function getStyle() {
return isset($_SESSION['switcherstyle']) ? $_SESSION['switcherstyle'] : 'default';
}

public function setStyle($style) {
$_SESSION['switcherstyle'] = $style;
}

public function getType() {
return isset($_SESSION['switchertype']) ? $_SESSION['switchertype'] : 'web';
}

public function setType($type) {
$_SESSION['switchertype'] = $type;
$this->setStyle('default');
}

public function viewSwitchType() {
$return = '';
$x = 1;
$cnt = sizeof($this->getTypeNames());
if ($cnt > 0) {
$return = '<div>';
foreach ($this->getTypeNames() as $type) {
$return .= '<a href="?switchertype=' . $type . '">' . $type . '</a>';
if ($x != $cnt) {
$return .= ' | ';
}
$x++;
}
$return .= '</div>';
}
return $return;
}

public function viewSwitchStyle() {
$return = '';
$x = 1;
$cnt = sizeof($this->getStyleNames());
if ($cnt > 0) {
$return = '<div>';
foreach ($this->getStyleNames() as $dir) {
$return .= '<a href="?switcherstyle=' . $dir . '">' . $dir . '</a>';
if ($x != $cnt) {
$return .= ' | ';
}
$x++;
}
$return .= '</div>';
}
return $return;
}

public function check() {
if (isset($_GET['switchertype'])) {
$type = $_GET['switchertype'];
if (in_array($type, $this->getTypeNames())) {
$this->setType($type);
$this->redirect();
}
} elseif (isset($_GET['switcherstyle'])) {
$style = $_GET['switcherstyle'];
if (in_array($style, $this->getStyleNames())) {
$this->setStyle($style);
$this->redirect();
}
}

}

public function getElement($element) {
$exp = explode('/', $element);
return end($exp);
}

public function redirect() {
ob_end_clean();
ob_start();
header('Location: ' . $_SERVER['HTTP_REFERER']);
ob_end_flush();
exit;
}

}