<?php
class KSwitcher {
    private $switchTypes;
    private $switchStyles;
    private $autodetect = 0; // 0 -> off | 1 -> on | 2 -> user select

    public function __construct() {
        $this->setTypeNames();
        $this->setStyleNames();
        $this->check();
        $_SESSION['path'] = '/theme/' . $this->getType() . '/' . $this->getStyle() . '/';
        #$this->render();
    }

    public function head() {
        global $set, $user_id, $act, $lng, $login, $datauser, $agn, $rights, $headmod, $rootpath;
        $head = file_exists($rootpath . 'theme/' . $this->getType() . '/' . $this->getStyle() . '/head.php') ? $rootpath . 'theme/' . $this->getType() . '/' . $this->getStyle() . '/head.php' : $rootpath . 'theme/' . $this->getType() . '/default/head.php';
        include($head);
    }

    public function end() {
        global $set, $user_id, $act, $lng, $login, $datauser, $agn, $rights, $headmod, $rootpath;
        $end = file_exists($rootpath . 'theme/' . $this->getType() . '/' . $this->getStyle() . '/end.php') ? $rootpath . 'theme/' . $this->getType() . '/' . $this->getStyle() . '/end.php' : $rootpath . 'theme/' . $this->getType() . '/default/end.php';
        include($end);
    }

    public function main() {
        global $set, $user_id, $act, $lng, $login, $datauser, $agn, $rights, $headmod, $rootpath;
        $main = file_exists($rootpath . 'theme/' . $this->getType() . '/' . $this->getStyle() . '/main.php') ? $rootpath . 'theme/' . $this->getType() . '/' . $this->getStyle() . '/main.php' : $rootpath . 'theme/' . $this->getType() . '/default/main.php';
        include($main);
    }

    public function render() {
        $this->head();

#        $this->main();

        $this->end();
    }

    public function getTypeNames() {
        return $this->switchTypes;
    }

    public function setTypeNames() {
        $this->switchTypes = array_map(array($this, 'getElement'), glob('theme/*'));
    }

    public function getStyleNames() {
        return $this->switchStyles;
    }

    public function setStyleNames() {
        $this->switchStyles = array_map(array($this, 'getElement'), array_diff(glob('theme/' . $this->getType() . '/*'), array('theme/' . $this->getType() . '/default')));
    }

    public function getStyle() {
        return isset($_SESSION['switcherstyle']) ? $_SESSION['switcherstyle'] : 'default';
    }

    public function setStyle($style) {
        $_SESSION['switcherstyle'] = $style;
    }

    public function getType() {
        return isset($_SESSION['switchertype']) ? $_SESSION['switchertype'] : 'web';
    }

    public function setType($type) {
        $_SESSION['switchertype'] = $type;
        $this->setStyle('default');
    }

    public function viewSwitchType() {
        $return = '';
        $x = 1;
        $cnt = sizeof($this->getTypeNames());
        if ($cnt > 0) {
            $return = '<div>';
            foreach ($this->getTypeNames() as $type) {
                $return .= '<a href="?switchertype=' . $type . '">' . $type . '</a>';
                if ($x != $cnt) {
                    $return .= ' | ';
                }
                $x++;
            }
            $return .= '</div>';
        }
        return $return;
    }

    public function viewSwitchStyle() {
        $return = '';
        $x = 1;
        $cnt = sizeof($this->getStyleNames());
        if ($cnt > 0) {
            $return = '<div>';
            foreach ($this->getStyleNames() as $dir) {
                $return .= '<a href="?switcherstyle=' . $dir . '">' . $dir . '</a>';
                if ($x != $cnt) {
                    $return .= ' | ';
                }
                $x++;
            }
            $return .= '</div>';
        }
        return $return;
    }

    public function check() {
        if (isset($_GET['switchertype'])) {
            $type = $_GET['switchertype'];
            if (in_array($type, $this->getTypeNames())) {
                $this->setType($type);
                $this->redirect();
            }
        } elseif (isset($_GET['switcherstyle'])) {
            $style = $_GET['switcherstyle'];
            if (in_array($style, $this->getStyleNames())) {
                $this->setStyle($style);
                $this->redirect();
            }
        }

    }

    public function getElement($element) {
        $exp = explode('/', $element);
        return end($exp);
    }

    public function redirect() {
        ob_end_clean();
        ob_start();
        header('Location: ' . $_SERVER['HTTP_REFERER']);
        ob_end_flush();
        exit;
    }

}