<?php

////////////////////////////////////
/// CURL функция. Автор  Koenig/////
////////////////////////////////////
function curl($url, $post='', $mode=array()) {

    $defaultmode = array('charset' => 'utf-8', 'ssl' => 0, 'cookie' => 0, 'headers' => 1, 'useragent' => 'Opera/9.80 (Windows NT 5.1; U; ru) Presto/2.10.229 Version/11.61');

    foreach ($defaultmode as $k => $v) {
        if (!isset($mode[$k]) ) {
            $mode[$k] = $v;
        }
    }

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HEADER, $mode['headers']);
    curl_setopt($ch, CURLOPT_REFERER, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_USERAGENT, $mode['useragent']);
    curl_setopt($ch, CURLOPT_ENCODING, $mode['charset']);
    curl_setopt($ch, CURLOPT_AUTOREFERER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 200);
    if ($post) {
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    }
    if ($mode['cookie']) {
        curl_setopt($ch, CURLOPT_COOKIEFILE, dirname(__FILE__).'/cookie.txt');
        curl_setopt($ch, CURLOPT_COOKIEJAR, dirname(__FILE__).'/cookie.txt');
    }
    curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
    if ($mode['ssl']) {
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    }
    $data = curl_exec($ch);
    curl_close($ch);
    return $data;
}