<?php
    //Инициируем сессию
    session_start();
    //Формируем массив для автозаполнения полей "имя" и "E-Mail"
    $_SESSION['log']=array($_POST['login'],$_POST['email']);
    //Если кнопка нажата
    if (isset($_POST)){
        //Подключаем файл с функциями
        require('func.php');
        //Удаляем пробелы и преобразуем спецсимволы 
        $login = trim(htmlspecialchars($_POST['login']));
        $email = trim(htmlspecialchars($_POST['email']));
        $msg = trim(htmlspecialchars($_POST['msg']));
        //Обрабатываем переменную "$msg" пользоват.функ-ей(см.файл func.php)
        $msg = replace($msg);
        //Получаем дату и время
        $date = date('Y.m.d - H:i:s');
        //Определяем IP
        $ip = $_SERVER['REMOTE_ADDR'];
        //Присваиваем через разделитель все данные в одну переменную
        $str = $email.'|'.$login.'|'.$date.'|'.$msg.'|ip: '.$ip."\n";
        //Формируем массив с ошибками
        if (empty($login)){
            $_SESSION['err'][0]='Введите имя!';
        }
        if (!empty($email)){
            if (preg_match('/[0-9a-z_\.\-]+@[0-9a-z_\.\-]+\.[a-z]{2,4}/i',$email)==FALSE){
            $_SESSION['err'][1]='Некорректный E-Mail!';
            }
        }
        if (empty($msg)){
            $_SESSION['err'][2]='Введите сообщение!';
        }
        //Если поля "имя","сообщение" непусты,и пуст массив ошибок E-Mail
        if (!empty($login) && !empty($msg) && empty($_SESSION['err'][1])){
            //Записываем строку в конец файла
            file_put_contents('data.txt', $str, FILE_APPEND);
        }

    }
    //Возвращаемся на страницу с формой
    header("Location: index.php");
?>