<?php
class chip_password_generator {
	
	private $args = array(
						'length'				=>	8,
						'alpha_upper_include'	=>	TRUE,
						'alpha_lower_include'	=>	TRUE,						
						'number_include'		=>	TRUE,
						'symbol_include'		=>	TRUE,	
					);
	
	private $alpha_upper = array( "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z" );
	private $alpha_lower = array( "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z" );
	private $number = array( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 );
	private $symbol = array( "-", "_", "^", "~", "@", "&", "|", "=", "+", ";", "!", ",", "(", ")", "{", "}", "[", "]", ".", "?", "%", "*", "#" );
	private $input = 4;
	
	public function __construct( $args = array() ) {
		
		$this->set_args( $args );
						
	}
	
	public function chip_print( $var ) { 
		
		echo "<pre>";
    	print_r($var);
   	 	echo "</pre>";
	
	}
	
	private function chip_parse_args( $args = array(), $defaults = array() ) { 
		return array_merge( $defaults, $args );	 
	}
	
	private function set_args( $args = array() ) { 
		
		$defaults = $this->get_args();
		$args = $this->chip_parse_args( $args, $defaults );
		$this->args = $args;	 
	}
	
	public function get_args() { 
		return $this->args;	 
	}
	
	private function get_alpha_upper() { 
		return $this->alpha_upper;	 
	}
	
	private function get_alpha_lower() { 
		return $this->alpha_lower;	 
	}
	
	private function get_number() { 
		return $this->number;	 
	}
	
	private function get_symbol() { 
		return $this->symbol;	 
	}
	
	private function set_password() {
		
		$temp = array();
		$exec = array();
		
		$args = $this->get_args();	 
		extract($args);
		
		if( $length <= 0 ) {
			return 0;
		}
		
		if( $alpha_upper_include == TRUE ) {
			$alpha_upper = $this->get_alpha_upper();
			$exec[] = 1;
		}
		
		if( $alpha_lower_include == TRUE ) {
			$alpha_lower = $this->get_alpha_lower();
			$exec[] = 2;
		}
		
		if( $number_include == TRUE ) {
			$number = $this->get_number();
			$exec[] = 3;
		}
		
		if( $symbol_include == TRUE ) {
			$symbol = $this->get_symbol();
			$exec[] = 4;
		}
		
		$exec_count = count( $exec ) - 1;
		$input_index = 0;
		//$this->chip_print( $exec );
		
		for ( $i = 1; $i <= $length; $i++ ) {
			
			switch( $exec[$input_index] ) {
				
				case 1:				
				shuffle( $alpha_upper );
				$temp[] = $alpha_upper[0];
				unset( $alpha_upper[0] );				
				break;
				
				case 2:				
				shuffle( $alpha_lower );
				$temp[] = $alpha_lower[0];
				unset( $alpha_lower[0] );				
				break;
				
				case 3:				
				shuffle( $number );
				$temp[] = $number[0];
				unset( $number[0] );				
				break;
				
				case 4:				
				shuffle( $symbol );
				$temp[] = $symbol[0];
				unset( $symbol[0] );				
				break;
				
			}
			
			if ( $input_index < $exec_count ) {
				$input_index++;
			} else {
				$input_index = 0;
			}
		
		} // for ( $i = 1; $i <= $length; $i++ )
		
		shuffle($temp);
		
		$password = implode( $temp );
		
		return $password;
		
	}	
	
	public function get_password() { 		
		return $this->set_password();		
	}
	
	public function __destruct() {
	}
}
?>