<?php

/**
 * @author Mixlion
 * @copyright Mixlion 09.01.2012
 * @version 1.5 beta
 * @link http://mixlion.ru
 * @desc Youtube Tools - Get information and direct links to youtube video
 */
 
class YT {

    /**
     * @var array $info - Video data
     */
    private static $info;

    /**
     * @var string $id - Video id
     */
    private static $id;

    /**
     * @var array $links - Links array
     */
    private static $links = array();

    /**
     * @var array $data - Media information about video
     */
    private static $data = array();

    /**
     * @var string $user_agent - useragent for getting data
     * Can be edited
     */
    private static $user_agent = 'Opera/9.80 (Windows NT 5.1; U; ru) Presto/2.10.229 Version/11.61';

    /**
     * @var array $formats - Formats of youtube video
     */
    private static $formats = array(
        '5'=>'flv',
        '6'=>'flv',
        '34'=>'flv',
        '35'=>'flv',
        '18'=>'mp4',
        '22'=>'mp4',
        '37'=>'mp4',
        '38'=>'mp4',
        '83'=>'mp4',
        '82'=>'mp4',
        '85'=>'mp4',
        '84'=>'mp4',
        '43'=>'webm',
        '44'=>'webm',
        '45'=>'webm',
        '46'=>'webm',
        '100'=>'webm',
        '101'=>'webm',
        '102'=>'webm',
        '13'=>'3gp',
        '17'=>'3gp',
        '36'=>'3gp'
    );

    public static function init($id = null){
        self::$data = self::$links = self::$info = null;
        self::$id = $id;
    }

    /**
     * Method for processing getting information about video
     * @return array|null
     */
    public static function get_info(){

        if(empty(self::$id)) die('Enter video id');
        if(!empty(self::$info)) return self::$info;
        # Get video data
        $data = curl('http://www.youtube.com/get_video_info?video_id='. self::$id);

        # Parsing data
        parse_str($data, $info);

        # Check the returned status
        if(@$info['status'] == 'ok') {
            self::$info = $info;
            return $info;
        } else {
            return false;
        }
    }

    /**
     * Method for getting direct links to video
     * @return array
     */
    public static function get_links(){
        if(!empty(self::$links)) return self::$links;
        if(empty(self::$info)) self::get_info();
        $links_map = explode(',',self::$info['url_encoded_fmt_stream_map']);
        $fmt_list = explode(',',self::$info['fmt_list']);
        if(empty($links_map) || (sizeof($links_map) == 1 && empty($links_map[0]))) return false;
        foreach($links_map as $key => $link){
            parse_str($link,$parts);
            //$link = $parts['url'].='&signature='.$parts['sig'];
			$link = $parts['url'];
            $fmt_parts = explode('/', $fmt_list[$key],3);
            # Create array of information of video
            self::$links[self::$formats[$parts['itag']] .'-'. $fmt_parts[1]] = array(self::$formats[$parts['itag']], $fmt_parts[1], $link);
        }
        return self::$links;
    }

    /**
     * Method to save video to local path
     * @param $video - Video type
     * @param $path - Dir to save video
     * @param null|string $name - Name of video (without extension)
     */
    public static function save($video, $path, $name = null){
        if(empty(self::$links)) self::get_links();
        if(!isset(self::$links[$video])) die('Video `'. $video .'` not found');

        # Define name of video
        $name = empty($name) ? self::$info['title'] : $name;
        if($path[mb_strlen($path, 'utf-8')-1] != '/') $path .= '/';
        $url = self::$links[$video][2] . '&title='. urlencode($name);
        # Handle for copy video
        $fo = fopen($path . $name . '.' . self::$links[$video][0], 'w');
		$ch = curl($url, $fo);
        fclose($fo);
    }

    /**
     * Method for getting data about video
     * @return array
     */
    public static function get_data(){
        if(!empty(self::$data)) return self::$data;
        if(empty(self::$info)) self::get_info();
        $entry = simplexml_load_file('http://gdata.youtube.com/feeds/mobile/videos/' . self::$id);
        $media = $entry->children('http://search.yahoo.com/mrss/');
        $entry->registerXPathNamespace('feed', 'http://www.w3.org/2005/Atom');
        $related = $entry->xpath("feed:link[@rel='http://gdata.youtube.com/schemas/2007#video.related']");
        $related = (string)$related[0]['href'];
        $data = array(
            'keywords' => self::$info ['keywords'],
            'title' => (string)$entry->title,
            'description' => (string)$media->group->description,
            'category' => (string)$media->group->category,
            'duration' => self::$info ['length_seconds'],
            'views' => self::$info ['view_count'],
            'rate' => self::$info ['avg_rating'],
            'thumbnails' => array(
                'big' => self::$info ['iurlmaxres'],
                'small' => self::$info ['iurlsd'],
                'default' => (string)$media->group->thumbnail[0]->attributes()->url,
                1 => (string)$media->group->thumbnail[1]->attributes()->url,
                2 => (string)$media->group->thumbnail[2]->attributes()->url,
                3 => (string)$media->group->thumbnail[3]->attributes()->url
            ),
            # Link for get related videos
            'related' => $related
        );
        self::$data = $data;
        return $data;
    }

    /**
     * Method for getting video and output to browser (test method)
     * @param string $video - Type video for getting
     */
    public static function get($video) {
        if(empty(self::$links)) self::get_links();
        if(!isset(self::$links[$video])) die('Video `'. $video .'` not found');

        $url = self::$links[$video][2];
        
		$ch = curl($url);
        $res = curl_getinfo($ch);
        
        if($res['content_type'] == 'video/webm') $ext = 'webm';
        elseif($res['content_type'] == 'video/x-flv') $ext = 'flv';
        elseif($res['content_type'] == 'video/mp4') $ext = 'mp4';
        elseif($res['content_type'] == 'video/3gpp') $ext = '3gp';
        header('Content-Type: '. $res['content_type']);
        header('Content-Length: '. $res['download_content_length']);
        header('Content-Disposition: attachment; filename='. urlencode(self::$info['title']).'.'.$ext);

        $ch = curl($res['url']);
    }
}
