<?php
define('_IN_JOHNCMS', 1);
$headmod = 'graphics';
$textl = 'Image Editor';
require_once("incfiles/core.php");
require_once("incfiles/head.php");
echo '<div class="phdr"><b>Image Editor</b></div>';
$u = isset($_POST['url']) ? functions::check(mb_substr(trim($_POST['url']), 0, 120)) : '';
$px = isset($_POST['pxl']) ? functions::check(mb_substr(trim($_POST['pxl']), 0, 4)) : '';
$cns = isset($_POST['cons']) ? functions::check(mb_substr(trim($_POST['cons']), 0, 4)) : '';
$w = isset($_POST['width']) ? functions::check(mb_substr(trim($_POST['width']), 0, 4)) : '';
$h = isset($_POST['height']) ? functions::check(mb_substr(trim($_POST['height']), 0, 4)) : '';

if (isset($_POST['submit'])) {
$error = array();
if (empty($u)) {
$error['u'][] = 'Image Url cannot be empty!';
} elseif (mb_strlen($u) < 8 || mb_strlen($u) > 120) {
$error['u'][] = 'Invalid url length!';
}

if (empty($px)) {
$error['px'][] = 'Pixel cannot be empty!';
} elseif (mb_strlen($px) > 4) {
$error['px'][] = 'Pixel length is too long!';
}

if (!preg_match("/^[0-9]{1,4}/i", $px)) {
$error['px'][] = 'Invalid pixel format!';
}

if (empty($cns)) {
$error['cns'][] = 'Constrain cannot be empty!';
} elseif (mb_strlen($cns) > 4) {
$error['cns'][] = 'Constrain length is too long!';
}

if (!preg_match("/^[0-9]{1,4}/i", $cns)) {
$error['cns'][] = 'Invalid Constrain format!';
}

if (empty($w)) {
$error['w'][] = 'Width cannot be empty!';
} elseif (mb_strlen($w) > 4) {
$error['w'][] = 'Width too long!';
}

if (!preg_match("/^[0-9]{1,4}/i", $w)) {
$error['w'][] = 'Invalid width format!';
}

if (empty($h)) {
$error['h'][] = 'Heght cannot be empty!';
} elseif (mb_strlen($h) > 4) {
$error['h'][] = 'Height length too long!';
}

if (!preg_match("/^[0-9]{1,4}/i", $h)) {
$error['h'][] = 'Invalid height format!';
}

if (empty($error)) {
header ('Content-type: image/jpeg');

$x = @getimagesize($u);

$sw = $x[0];

$sh = $x[1];

if ($px > 0) {

	$px = $px * 0.01;
	$w = $sw * $px;
	$h = $sh * $px;
} else {
	if (isset ($w) AND !isset ($h)) {
	
		$h = (100 / ($sw / $w)) * .01;
		$h = @round ($sh * $h);
	} elseif (isset ($h) AND !isset ($w)) {

		$w = (100 / ($sh / $h)) * .01;
		$w = @round ($sw * $w);
	} elseif (isset ($h) AND isset ($w) AND isset ($cns)) {
		$hx = (100 / ($sw / $w)) * .01;
		$hx = @round ($sh * $hx);

		$wx = (100 / ($sh / $h)) * .01;
		$wx = @round ($sw * $wx);

		if ($hx < $h) {
			$h = (100 / ($sw / $w)) * .01;
			$h = @round ($sh * $h);	
		} else {
			$w = (100 / ($sh / $h)) * .01;
			$w = @round ($sw * $w);
		}
	}
}

$im = @ImageCreateFromJPEG ($u) or 
$im = @ImageCreateFromPNG ($u) or 
$im = @ImageCreateFromGIF ($u) or 
$im = false; 

if (!$im) {
	
	readfile ($u);
} else {	
	$thumb = @ImageCreateTrueColor ($w, $h);

	@ImageCopyResampled ($thumb, $im, 0, 0, 0, 0, $w, $h, $sw, $sh);

	@ImageJPEG ($thumb);
}
}
}

echo '<div class="menu"><form method="post" action="imgcnv.php"><b>Url:</b><br/>' .
(isset($error['u']) ? '<span class="red">' . implode('<br/>', $error['u']) . '</span><br />' : '') .
'<input type="url" name="url" value="http://"' . (isset($error['u']) ? ' style="background-color: #FFCCCC"' : '') . ' maxlength="120" /><br/><b>Pixel:</b><br/>' .
(isset($error['px']) ? '<span class="red">' . implode('<br/>', $error['px']) . '</span><br />' : '') .
'<input type="number" name="pxl" value="20"' . (isset($error['px']) ? ' style="background-color: #FFCCCC"' : '') . ' maxlength="4" size="5" /><br/><b>Constrain</b><br/>' .
(isset($error['cns']) ? '<span class="red">' . implode('<br/>', $error['cns']) . '</span><br />' : '') .
'<input type="number" name="cons" value="20"' . (isset($error['cns']) ? ' style="background-color: #FFCCCC"' : '') . ' maxlength="4" size="5"/><br/>' .
'<b>Width x Height:</b><br/>' .
(isset($error['w']) ? '<span class="red">' . implode('<br/>', $error['w']) . '</span><br />' : '') .
'<input type="number" name="width" value="145"' . (isset($error['h']) ? ' style="background-color: #FFCCCC"' : '') . ' maxlength="4" size="4" />x' .
(isset($error['h']) ? '<span class="red">' . implode('<br/>', $error['h']) . '</span><br />' : '') .
'<input type="number" name="height" value="160"' . (isset($error['h']) ? ' style="background-color: #FFCCCC"' : '') . ' maxlength="4" size="4" /><br/><input type="submit" name="submit" value="Submit" /></form></div>';
require_once("incfiles/end.php");
?>
