<?php

defined('_IN_JOHNCMS') or die('Error: restricted access');
require('../incfiles/head.php');
/*
  -----------------------------------------------------------------
  Проверяем права доступа
  -----------------------------------------------------------------
 */
if ($user['id'] != $user_id) {
    echo functions::display_error($lng['access_forbidden']);
    require('../incfiles/end.php');
    exit;
}

/*
  -----------------------------------------------------------------
  Подключение конфига и языковых файлов
  -----------------------------------------------------------------
 */
$lng_smile = core::load_lng('smile');
$settings_personalsmile = parse_ini_file('./includes/profile/settings_personalsmile.ini');

/*
  -----------------------------------------------------------------
  Создание файлов и папок нужных для работы
  -----------------------------------------------------------------
 */
if (!(file_exists('../images/smileys/user/personal'))) {
    mkdir('../images/smileys/user/personal');
}
file_put_contents('../images/smileys/user/personal/index.php');
if (!(file_exists('../images/smileys/user/personal/' . $user_id))) {
    mkdir('../images/smileys/user/personal/' . $user_id);
}
file_put_contents('../images/smileys/user/personal/' . $user_id . '/index.php');

/*
  -----------------------------------------------------------------
  Подключение списка смайлов и подсчет их количества
  -----------------------------------------------------------------
 */
$listSmile = array_diff(scandir('../images/smileys/user/personal/' . $user_id . '/'), array('.', '..', 'index.php'));
$count = count($listSmile);

echo '<div class="phdr">' . $lng_smile["listsmile"] . '</div>';
if ($count > 0) {
    echo '<form action="profile.php?act=deletepersonalsmile" method="post">' .
    '<div class="menu"><table width="80%">' .
    '<tr><td>' . $lng_smile["smilecode"] . '</td><td>' . $lng_smile["pic"] . '</td></tr><br />';

    foreach (($listSmile) as $img) {
        $code = explode('.', $img);
        echo '<tr><td><input type="checkbox" name="smile[]" value="' . $img . '"/></td><td>:' . $code[0] . '</td><td><img src = "../images/smileys/user/personal/' . $user_id . '/' . $img . '"/></td></tr>';
    }
    echo '</table></div>';
    echo '<input type="submit" value="' . $lng_smile["delete"] . '" /></form>';
}

echo '<div class="gmenu">' . $lng_smile["total"] . ': ' . $count . '</div>';

if ($count <= (int) $settings_personalsmile["total"]) {
    echo '<div class="menu"><a href="profile.php?act=addpersonalsmile">' . $lng_smile["addpersonalsmile"] . '</a></div>';
}
