<?php

/*
** Автор кода: Евгений (rnddev)
** ICQ: 448235
** Email: rnddev@mail.ru
** Skype: rnddev
** Все права принадлежат автору
** Модефикация и продажа запрещена
*/

defined('ACCESS') or die('Error::Access');

class check {	
	
	public static function input($value, $type, $mode = 'check'){
		$filterinput = array(
			"MAIL"		=>	array("^[a-zA-Z0-9_.-]+\@[a-zA-Z0-9_.-]+\.[a-zA-Z]{2,5}$", "xxx@yyy.zz"),
			"LOGIN"		=>	array("^[a-zA-Z0-9]{3,50}$","латинские буквы и цифры, не менее трех символов"),
			"PASSWORD"	=>	array("^[a-zA-Z0-9.,!#%*()$]{6,20}$","от 6 латинских букв, цифр и знаков: .,!#%*()$"),
			"INT"		=>	array("^\-?[0-9]*$","только цифры"),
			"FLOAT"		=>	array("^\-?[0-9]*\.?[0-9]*$","целаячасть.дробная"),
			"IP"		=>	array("^[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}$","XXX.XXX.XXX.XXX"),
			"WORD"		=>	array("^[0-9a-z_/]*$","только английские буквы и цифры"),
			"ROUTE"		=>	array("^[0-9a-z_-]*$","только английские буквы и цифры"),
			"URL"		=>	array("^(https?|HTTPS?|ftp|gopher):\/\/[a-zA-Z0-9_-]+(\.[a-zA-Z0-9-]+)*\.[a-zA-Z]{1,7}".// Основное имя сервера
							"(\/[a-zA-Z0-9\_\.-]*\/?)*". // Имена возможных подкаталогов и файл
							"(\?[a-zA-Z0-9\_]+=[a-zA-Z0-9]+([&][a-zA-Z0-9_]+=[a-zA-Z0-9]+)*)?$"//get параметр
							,"http://site.com/path/"),
			"TIME"		=>	array("^[0-9]{2}(:[0-9]{2})?(:[0-9]{2})?$","ЧЧ:ММ:СС"),
			"DATE"		=>	array("^[0-9]{4}-[0-9]{2}-[0-9]{2}$","ГГГГ-ММ-ДД"),
			"DATETIME"	=>	array("^[0-9]{4}-[0-9]{2}-[0-9]{2}([ ]+[0-9]{2}:[0-9]{2}:[0-9]{2}){0,1}$","ГГГГ-ММ-ДД ЧЧ:ММ:СС"),
			"NUMPHONE"	=>	array("^\+?[0-9 ()-]{5,20}$","только цифры"),
			"SESSION"	=>	array("^[0-9a-zA-Z]*$","правильная сессия"),
			"FILE"		=>	array("^[0-9a-zA-Z_.-]*$","только английские буквы и цифры"),
			"DOMAIN"	=>	array("^[a-z0-9\.\-]{2,50}$","только английские буквы и цифры")
		);

		if($mode == 'check')
		return preg_match('~'. $filterinput[$type][0] .'~', $value);
		elseif($mode == 'format')
		return $filterinput[$type][1];
	}
	
	public static function bbcode($markup){
		$preg = array(
			# Text arrtibutes
			'~\[b\](.*?)\[\/b\]~si' => '<b>$1</b>',
			'~\[i\](.*?)\[\/i\]~si' => '<i>$1</i>',
			'~\[u\](.*?)\[\/u\]~si' => '<u>$1</u>',

			# цвет текста
			'~\[red\](.*?)\[\/red\]~si' => '<font color="red">$1</font>',
			'~\[green\](.*?)\[\/green\]~si' => '<font color="green">$1</font>',
			'~\[blue\](.*?)\[\/blue\]~si' => '<font color="blue">$1</font>',

			# выравнивания
			'~\[center\](.*?)\[\/center\]~si' => '<div style="text-align: center">$1</div>',
			'~\[left\](.*?)\[\/left\]~si' => '<div style="text-align: left">$1</div>',
			'~\[right\](.*?)\[\/right\]~si' => '<div style="text-align: right">$1</div>',

			# код
			'/\[code\](.*)\[\/code\]/Usie' => "highlight('$1')",

			# цитаты
			'~\[q\](.*?)\[\/q\]~si' => '<div class="q">$1</div>',

			# e-mail
			'~\[email\](.*?)\[\/email\]~sei' => "'<a rel=\"noindex\" href=\"mailto:'.str_replace('@', '[dog]','$1').'\">'.str_replace('@', '[dog]','$1').'</a>'",

			# ссылки
			'~\[url=(.*?)?\](.*?)\[\/url\]~si'      => '<a href="$1">$2</a>',

			# images
			'~\[img\](.*?)\[\/img\]~si'             => "<img src=\"$1\" alt=\"\" style=\"max-width: 150px;\" />",
		);

	  	return preg_replace(array_keys($preg), array_values($preg), $markup);
	}
	
	public static function size($num) {
		if ( ! $num) $num = 0;

		if ($num >= 1000000000000) {
			$num = round($num / 1099511627776, 1);
			$unit = 'Тб';
		}
		elseif ($num >= 1000000000) {
			$num = round($num / 1073741824, 1);
			$unit = 'Гб';
		}
		elseif ($num >= 1000000) {
			$num = round($num / 1048576, 1);
			$unit = 'Мб';
		}
		elseif ($num >= 1000) {
			$num = round($num / 1024, 1);
			$unit = 'Кб';
		}
		else {
			$unit = 'б';
			return number_format($num).' '.$unit;
		}

		return number_format($num, 1).' '.$unit;
	}
	
}