function mailSubscribe(userID) {
    var socket;
    try {
        socket = new WebSocket("ws://127.0.0.1:8888/");
        socket.onopen = function() {
            socket.send(JSON.stringify({
                'action': 'mail_subscribe',
                'params': {
                    'user_id': userID
                }
            }))
        };
        socket.onmessage = function(msg) {
            msg = JSON.parse(msg.data);
            if (msg.hasOwnProperty('event')) {
                switch (msg.event) {
                    case 'new_mail_message':
                        var $unread = window.document.querySelector('#unread'), $num;
                        if ($unread) {
                            $num = $unread.querySelector('#mail_number');
                            $num.textContent = String(parseInt($num.textContent) + 1);
                        } else {
                            $unread = document.createElement('div');
                            $unread.id = 'unread';
                            var $label = document.createElement('span');
                            $label.textContent = 'Unread: ';
                            $unread.appendChild($label);
                            $num = document.createElement('span');
                            $num.id ='mail_number';
                            $num.textContent = '1';
                            $unread.appendChild($num);
                            var $c = document.querySelector('.maintxt');
                            $c.insertBefore($unread, $c.firstChild);
                        }
                        break;
                    default:
                        break;
                }
            }
        };
    } catch(ex){
        console.log(ex);
    }
}