<?php
# Define classes
$pollClass = POLL_DATA.'Poll';
$optionClass = POLL_DATA.'Options';
$voteClass = POLL_DATA.'Votes';

# Load poll details
$pollId = ($_GET['results']) ? $_GET['results'] : $pollId;
$optionId = ($_GET['optionId']) ? $_GET['optionId'] : '';
$voted = $_GET['voted'];
$poll = new $pollClass();
$poll->loadDetails($pollId);

# Check if already voted
$ipAddr = $_SERVER['REMOTE_ADDR'];
$votes = new $voteClass();
if (!$votes->checkIP($pollId,$ipAddr) && $poll->status == 1 && $voted == 'false') {
  # Multiple votes
  $optionIds = explode(',', $optionId);
  # Update poll
  foreach ($optionIds as $optionId) $poll->votes += 1;
  if (POLL_DATA == 'mysql') { 
    $poll->saveDetails();
  }
  else {
    $poll->xml->poll[$poll->pos]['votes'] = $poll->votes;
    $poll->saveFile();
  }
  # Update votes
  $votes = new $voteClass();
  foreach ($optionIds as $optionId) {
    $votes->addVote($optionId,$pollId);  
  }
}

# Load options
$options = new $optionClass();
if (POLL_DATA == 'mysql') {
  $options->addWhere('pollId = '.$pollId);
  $options->addWhere('status = 1');  // only active
  $options->addOrder('position');
  $options->loadList();
}
else {
  $options->loadList($pollId,true);  // only active
}

# Load and calculate votes
$maxVote = $poll->width - 60;  // 100% in pixels
$allVotes = $poll->votes;  // sum of all votes
$barPerc = ($allVotes > 0) ? 100 / $allVotes : 0;  // single vote percent ratio
$barScale = $barPerc * $maxVote / 100;  // scale for drawing bars
?>

<ul>

<?php
# Display results
if (is_array($options->objList)) {
  
  foreach($options->objList as $optionId) {
    $option = $options->loadDetails($optionId,$pollId);
    if (POLL_DATA == 'mysql') $option->order = $option->position;      
    # Load votes
    $votes = new $voteClass();
    if (POLL_DATA == 'mysql') {
      $votes->addWhere('pollId = '.$pollId);
      $votes->addWhere('optionId = '.$optionId);
      $vote = $votes->loadNumList();
    }
    else {
      $votes->loadList($optionId,$pollId);
      $vote = (isset($votes->voteCount)) ? $votes->voteCount : 0;
    }
    $barSize = $vote * $barScale;
    $voteNum = round($vote * $barPerc);
    ?>
    <li>
      <?php echo $option->title; ?>
      <div class="dracon_poll_bars_text"><?php echo $voteNum; ?></div>
      <div class="dracon_poll_bars" style="width:<?php echo $barSize; ?>px"></div>
      <span class="hidden"><?php echo $vote; ?></span>
      <span class="hidden"><?php echo $voteNum; ?></span>
    </li>
   <?php } ?>

<?php } ?>

</ul>