/****************************************************************************\
* Dracon AJAX Poll                                                           *
******************************************************************************
* Version: 1.6                                                               *
* Author: Searcher <searcher@dracon.biz>                                     *
* License: http://www.dracon.biz/license.php                                 *
\****************************************************************************/

SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Table structure for poll_base
-- ----------------------------
CREATE TABLE `poll_base` (
  `pollId` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) CHARACTER SET latin1 NOT NULL,
  `multiline` int(1) NOT NULL,
  `status` int(1) NOT NULL,
  `width` int(5) NOT NULL,
  `height` int(5) NOT NULL,
  `skin` varchar(20) CHARACTER SET latin1 NOT NULL,
  `effect` varchar(10) CHARACTER SET latin1 NOT NULL,
  `fxspeed` int(5) NOT NULL,
  `multichoice` int(5) NOT NULL DEFAULT '1',
  `votes` int(10) NOT NULL,
  PRIMARY KEY (`pollId`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Dracon AJAX Poll v1.4 - Base Table';

-- ----------------------------
-- Table structure for poll_option
-- ----------------------------
CREATE TABLE `poll_option` (
  `optionId` int(10) NOT NULL AUTO_INCREMENT,
  `pollId` int(10) NOT NULL,
  `title` varchar(200) CHARACTER SET latin1 NOT NULL,
  `position` int(1) NOT NULL,
  `bullet` int(2) NOT NULL,
  `status` int(1) NOT NULL,
  PRIMARY KEY (`optionId`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='Dracon AJAX Poll v1.4 - Options Table';

-- ----------------------------
-- Table structure for poll_vote
-- ----------------------------
CREATE TABLE `poll_vote` (
  `voteId` int(10) NOT NULL AUTO_INCREMENT,
  `optionId` int(10) NOT NULL,
  `pollId` int(10) NOT NULL,
  `ipAddress` varchar(20) CHARACTER SET latin1 NOT NULL,
  `voteTime` datetime NOT NULL,
  PRIMARY KEY (`voteId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Dracon AJAX Poll v1.4 - Votes Table';

-- ----------------------------
-- Records 
-- ----------------------------
INSERT INTO `poll_base` VALUES ('1', 'New Poll', '0', '1', '150', '150', 'default', 'fade', '200', '1', '0');
INSERT INTO `poll_option` VALUES ('1', '1', 'Option 1', '1', '1', '1');
INSERT INTO `poll_option` VALUES ('2', '1', 'Option 2', '2', '2', '1');
INSERT INTO `poll_option` VALUES ('3', '1', 'Option 3', '3', '3', '1');