<?php
# Load data
$config = file(POLL_ROOT.'include/config.php');
parse_str($_POST['data'], $cfgData);
# Define incoming data order
$cfgDataKeys = array('POLL_ADMIN_LOGIN','POLL_ADMIN_PASS','POLL_DB_HOST','POLL_DB_USER','POLL_DB_PASS','POLL_DB_NAME','POLL_DB_PREFIX','POLL_VOTED_TIME','POLL_WEB_ROOT','POLL_DATA','POLL_VOTED_SKIP_ANI','POLL_VOTED_ONCE','POLL_NO_RESULTS');

# Define options
$poll_cfg_edit = array(
  0 => array('POLL_ADMIN_LOGIN', 'admin login'),
  1 => array('POLL_ADMIN_PASS', 'admin password'),
  2 => array('POLL_VOTED_TIME', 'time in seconds before a new vote is allowed'),
  3 => array('POLL_VOTED_SKIP_ANI', 'skip animation if already voted'),
  4 => array('POLL_WEB_ROOT', 'make sure this is correct'),
  5 => array('POLL_DATA', 'xml, mysql'),
  6 => array('POLL_DB_HOST', 'edit address'),
  7 => array('POLL_DB_USER', 'edit username'),
  8 => array('POLL_DB_PASS', 'edit password'),
  9 => array('POLL_DB_NAME', 'edit db name'),
  10 => array('POLL_DB_PREFIX', 'set if you require a prefix'),
  11 => array('POLL_VOTED_ONCE', 'voting is allowed only once'),
  12 => array('POLL_NO_RESULTS', 'do not display results after voting')
);

# Rewrite new data
$confCounter = 0;
foreach ($config as $conf) {
  foreach ($poll_cfg_edit as $poll_cfg) {
    if (substr_count($conf, "'".strtoupper($poll_cfg[0])."'")) {
      $cfgKey = array_search(strtoupper($poll_cfg[0]), $cfgDataKeys);  // locate key
      // true&false checkbox quick fix
      if ($cfgDataKeys[$cfgKey] != 'POLL_VOTED_SKIP_ANI' && $cfgDataKeys[$cfgKey] != 'POLL_VOTED_ONCE' && $cfgDataKeys[$cfgKey] != 'POLL_NO_RESULTS') $cfgData[$cfgKey] = '\''.$cfgData[$cfgKey].'\'';
      // assign valuess
      $config[$confCounter] = "define('".strtoupper($poll_cfg[0])."', ".$cfgData[$cfgKey].");  // ".$poll_cfg[1]." \n";
    }
  }
	$confCounter++;
}

# Save file
$newConf = '';
foreach ($config as $conf) $newConf .= $conf;
$success = file_put_contents(POLL_ROOT.'include/config.php', $newConf);
?>
<table cellpadding="15" cellspacing="1" style="border:1px solid #ccc; background:#fff; font-size:12px; margin-top:10px" width="600">
	<tr style="background:#efefef">
		<td align="center">
      <?php
      if (isset($success)) {
      ?>
			  <span style="color:green"><b>Congratulations, you have finished the installation successfully!</b></span>
			  <br /><br />
			  You can manage your polls now via
        <br /><br />
        <a target="_blank" href="<?php echo trim($cfgData[8],'\''); ?>admin/" class="dracon_poll_admin_link" style="font-size:12px"><?php echo trim($cfgData[8],'\''); ?>admin/</a>
        <br /><br />
			  Login: <strong><?php echo trim($cfgData[0], '\''); ?></strong>
        <br />
			  Password: <strong><?php echo trim($cfgData[1],'\''); ?></strong>
			  <br /><br />
			  <span style="color:red">Please remove the <b>install</b> folder to complete the installation!</span>
        <br /><br />
        If you wish to amend your settings, please run the installation process <a href="" class="dracon_poll_admin_link" style="font-size:12px">again</a>
        <br />
        (all altered data are stored already and will be prefilled) 
        <br />
        or edit your config file directly <strong>include/config.php</strong>
      <?php } else { ?>
        <span style="color:red">
          <strong>Warning</strong>
          <br /><br />
          An error occured while saving the configuration file!
          <br />
          Please check file permissions again and make sure the config file is not being used by another program.</span>
      <?php } ?>
		</td>
	</tr>
</table>