<?php
require '../src/RBlackListSitesConfig.php';
$config_file = 'data/config.json';
$config = new RBlackListSitesConfig($config_file);
$act = isset($_GET['act']) ? $_GET['act'] : null;

switch ($act){
    case 'mask' :
        if (isset($_GET['id']) === false){
            exit('Укажите маску');
        }else if ($config->removeMask(rawurldecode($_GET['id']))){
            header('Location: index.php');
        }else{
            errors($config);
        }
    break;
    case 'site' :
        if (isset($_GET['domain'], $_GET['host']) === false){
            exit('Не указан хост или маска');
        }else if ($config->removeSite(rawurldecode($_GET['host']), rawurldecode($_GET['domain']))){
            header('Location: index.php');
        }else{
            errors($config);
        }
    break;
    default:
        header('Location: index.php');
    break;
}

/**
 * Выводим ошибки
 * @param $config
 * @return void
 */
function errors($config){
    echo '<ul>';
    foreach ($config->getErrors() as $error){
        echo '<li>' . $error . '</li>';
    }
    echo '</ul>';
}