<?php
define('_IN_JOHNCMS', 1);
$textl = "Георгиевская ленточка на аватар";
require_once ("../incfiles/core.php");
require_once ("../incfiles/head.php");
function clear($file = false) {
    if ($file && file_exists($file)) {
        unlink($file);
    } else {
        $arr = glob("images_tmp/*");
        if (!empty($arr)) {
            foreach ($arr as $value) {
                if (filemtime($value) < time() - 300) unlink($value);
            }
        }
    }
}
function sizeImg($file) {
    if (!file_exists($file)) return "Файл отсутствует!";
    $filesize = filesize($file);
    if ($filesize > 1024) {
        $filesize = round($filesize / 1024, 1);
        return $filesize . " Кб";
    } else {
        $filesize = round($filesize, 1);
        return $filesize . " байт";
    }
}
function resampl($file, $angle = 0, $rat = false) {
    $size = getimagesize($file);
    $format = strtolower(substr($size['mime'], strpos($size['mime'], '/') + 1));
    $icfunc = "imagecreatefrom" . $format;
    $newfile = "images_tmp/" . time() . "_9_may.png";
    if (!function_exists($icfunc)) {
        return $file;
    } else {
        $min = min(round($size[0] / 2.5), round($size[1] / 2.5));
        $nw = ($rat ? $min : round($size[0] / 2.5));
        $nh = ($rat ? $min : round($size[1] / 2.5));
        $img = imagecreatetruecolor($size[0], $size[1]);
        $trans = imagecolorallocatealpha($img, 0, 0, 0, 127);
        $photo = $icfunc($file);
        $band = imagecreatefrompng("img/band1.png");
        switch ($angle) {
            case '90':
                $band = imagerotate($band, $angle, 0);
                $top = $size[1] - $nh;
                $left = 0;
                break;

            case '180':
                $band = imagerotate($band, $angle, 0);
                $top = $size[1] - $nh;
                $left = $size[0] - $nw;
                break;

            case '270':
                $band = imagerotate($band, $angle, 0);
                $top = 0;
                $left = $size[0] - $nw;
                break;

            default:
                $top = 0;
                $left = 0;
                break;
        }
        imagesavealpha($img, true);
        imagefill($img, 0, 0, $trans);
        imagecopyresampled($img, $photo, 0, 0, 0, 0, $size[0], $size[1], $size[0], $size[1]);
        imagecopyresampled($img, $band, $left, $top, 0, 0, $nw, $nh, 65, 65);
        imagepng($img, $newfile);
        unlink($file);
        imagedestroy($img);
        imagedestroy($photo);
        imagedestroy($band);
        return $newfile;
    }
}

if (isset($_GET['clear'])) {
    clear(trim($_GET['clear']));
    header('Location: ./?');
}
echo '<div class="phdr">' . $textl . '</div>';
if (isset($_POST['submit']) && $_FILES['img']['size'] > 0) {
    $file = strtolower($_FILES['img']['name']);
    $al_ext = array('jpg', 'jpeg', 'png', 'gif');
    $ext = functions::format($file);
    if (!in_array($ext, $al_ext)) {
        echo functions::display_error("К загрузке разрешены файлы, имеющие расширение <b>" . implode("</b>, <b>", $al_ext) . "</b>!", '<a href="./?">Вернуться</a>');
    } elseif ($_FILES['img']['size'] > 1024 * 1024) {
        echo functions::display_error("К загрузке разрешены файлы не более <b>1Mb</b>!", '<a href="./?">Вернуться</a>');
    } else {
        $file = 'images_tmp/_' . time() . '.' . $ext;
        if ((move_uploaded_file($_FILES["img"]["tmp_name"], $file)) == true) {
            list($width, $height, $type, $attr) = getimagesize($file);
            if ($type > 3 || $type < 1) {
                echo functions::display_error("Недопустимый тип файла!", '<a href="./?">Вернуться</a>');
                clear($file);
            } elseif ($width > 700 || $width < 65 || $height > 700 || $height < 65) {
                echo functions::display_error("Недопустимый размер изображения! Разрешено выгружать минимум <b>65х65</b> и максимум <b>700х700</b> пикселей!", '<a href="./?">Вернуться</a>');
                clear($file);
            } else {
                $angl = intval($_POST['angl']);
                $ratio = isset($_POST['ratio']) ? true : false;
                switch ($angl) {
                    case '1':
                        $angle = 0;
                        break;

                    case '2':
                        $angle = 270;
                        break;

                    case '3':
                        $angle = 90;
                        break;

                    case '4':
                        $angle = 180;
                        break;

                    default:
                        $angle = 0;
                        break;
                }
                $image = resampl($file, $angle, $ratio);
                echo '<div class="list2" style="text-align: center;"><p><img src="' . $image . '" ' . $attr . ' alt="" /></p><p><a href="' . $image . '">Скачать (' . sizeImg($image) . ')</a> <a href="./?clear=' . $image . '">Сбросить</a></p></div>';
            }
        } else {
            echo functions::display_error("Ошибка при временном сохранении файла!", '<a href="./?">Вернуться</a>');
        }
    }
} else {
    clear();
    echo '<div class="list2"><p></p><form action="./?sb=1" method="POST" enctype="multipart/form-data"><p>Выберите файл (min: 65x65, max: 700x700, [jpeg, jpg, png, gif], max.size: 1Mb):<br/><input type="file" name="img" accept=".gif,.png,.jpg,.jpeg" /></p>';
    echo '<p>Положение:</p><p><label for="angl_1"><input id="angl_1" type="radio" name="angl" value="1" checked="checked" /> - верхний левый</label></p>';
    echo '<p><label for="angl_2"><input id="angl_2" type="radio" name="angl" value="2" /> - верхний правый</label></p>';
    echo '<p><label for="angl_3"><input id="angl_3" type="radio" name="angl" value="3" /> - нижний левый</label></p>';
    echo '<p><label for="angl_4"><input id="angl_4" type="radio" name="angl" value="4" /> - нижний правый</label></p>';
    echo '<p><label for="ratio"><input id="ratio" type="checkbox" name="ratio" value="1" /> - не учитывать соотношение сторон</label></p>';
    echo '<p><input type="submit" value="Отправить" name="submit" /></p>';
    echo '</form></div>';
}
echo '<div class="phdr">' . $textl . '</div>';
require_once ("../incfiles/end.php");
?>