<?
/****
* @package LiveCMS
* @link livecms.org
* @author MyZik
* @version See attached file VERSION.txt
* @license See attached file LICENSE.txt
* @copyright Copyright (C) LiveCMS Development Team
****/

class Core {
	public static $db; // Основная переменная для работы с БД
	public static $cms_set; // Настройки сайта
	public static $timeGen; // Генерация страницы
	public static $cms_version = '2.0'; // Версия движка (!НЕ МЕНЯТЬ!)
	public static $ip; // IP-адрес
	public static $browser; // Браузер
	public static $lang_iso; // Двухбуквенный код языка
	public static $lang_list = array(); // Список языков
	public static $lang = array(); // Язык сайта
	public static $set_user; // Настройки пользователя
	public static $countMess; // Кол-во сообщений на страницу
	public static $page; // Кол-во страниц
	public static $start; // Первая страница

	function __construct() {
		// Инициализация PDO, подключение к БД
		include '/incfiles/db_ini.php';
		$db = new PDO('mysql:host=' . $mysql['host'] .';dbname=' . $mysql['base'], $mysql['user'], $mysql['pass'], array(
				PDO::ATTR_PERSISTENT => true
		)) or die('Cannot connect to MySQL server :(');
		
		// Установка кодировки соединения
		@$db->query("SET NAMES utf8");
		
		$cms_set = $db->query("SELECT * FROM `cms_settings` WHERE `id` = '1'")->fetch();
		$timeGen = microtime(1);
		$ip = Functions::input($_SERVER['REMOTE_ADDR']);
		$browser = Functions::input($_SERVER['HTTP_USER_AGENT']);
		$lang_iso = self::$set_user['language'];		
		$lang = self::load_lng();
		
		/**
		 * Получаем файлы из /autoload/
		**/
		$dir = opendir(HOME .'/autoload/'); // Папка с нашими доп. функциями
		while ($file = readdir($dir)) {
			if (preg_match('/\.php$/i', $file))
				require_once(HOME .'/autoload/'. $file);
			
		if (isset($user)) {
			// Получаем настройки пользователя
			$set_user = $db->query("SELECT * FROM `user_settings` WHERE `user_id` = '" . $user['id'] . "'")->fetch();
			$countMess = (int)$set_user['num_pages']; // Число сообщений на страницу
		} else {
			// Системные настройки для гостей
			$set_user['num_pages'] = $cms_set['num_pages']; // Кол-во пунктов на страницу
			$set_user['sex_view'] = $cms_set['sex_view']; // Показ пола иконками (icons) или текстом (text)
			$set_user['theme'] = $cms_set['theme']; // Тема оформления
			$set_user['language'] = $cms_set['language']; // Язык
			$countMess = $set_user['num_pages'];
			}
			
		$page = isset($_REQUEST['page']) && $_REQUEST['page'] > 0 ? intval($_REQUEST['page']) : 1;
		$start = isset($_REQUEST['page']) ? $page * $countMess - $countMess : (isset($_GET['start']) ? abs(intval($_GET['start'])) : 0);
		}
		
		/**
		 * Проверяем наличие бана у пользователя
		 **/
		if (isset($user) && $db->query("SELECT COUNT(*) FROM `cms_banned_users` WHERE `user_id` = '" . $user['id'] . "' AND `ban_time` >= '" . time() . "'")->fetchColumn() != 0) {
			$title = 'You banned!';
			require_once(HOME . '/incfiles/header.php');
			$ban = $db->query("SELECT * FROM `cms_banned_users` WHERE `user_id` = '" . $user['id'] . "' AND `ban_time` >= '" . time() . "' LIMIT 1")->fetch();
			echo '<div class="error">' .
					'<center><b>' . $lang['you_banned'] . '</b></center>' .
					$lang['ban_while'] . ': ' . $ban['description'] . '<br />' .
					$lang['ban_date'] . ': ' . display_time($ban['time']) . '<br />' .
					$lang['ban_end'] . ': ' . display_time($ban['ban_time']) . '<br />' .
					$lang['ban_by'] . ': '; echo display_user($ban['admin_id']);
			echo '</div>';
			require_once(HOME . '/incfiles/footer.php');
		}
	}
	
	/**
	 * Функция подключения языкового пакета
	 * Аналогичная функция взята с CMS JohnCMS 4.x.x (http://johncms.com)
	**/
	public static function load_lng($module = '_core') {
		global $cms_set, $set_user;
		if (!is_dir(HOME . '/incfiles/languages/' . $lang_iso)) $lang_iso = $cms_set['language'];
		$lang_file = HOME . '/incfiles/languages/' . $set_user['language'] . '/' . $module . '.lng';
		if (file_exists($lang_file)) {
			$out = parse_ini_file($lang_file) or die('ОШИБКА! Файл языкового пакета не найден');
			return $out;
		}
		echo '<div class="alert alert-danger">Language file <b>' . HOME . '/' . $module . '.lng</b> is missing</div>';
		return FALSE;
	}
	
	/**
	  * Подключение библиотек / классов
	**/
	public static function require_lib($var) {
		if (file_exists(HOME .'/incfiles/classes/'. $var)) require_once(HOME .'/incfiles/classes/'. $var);
			else
		exit('Невозможно подключить библиотеку '. $var);
	}
	
	
	/**
	 * Функция шифрования пароля MD5 + BASE64
	**/
	public function encrypt($var) {
		return md5(base64_encode($var) . '_LiveCMS');
	}
}