<?php
/**
 * @Автор   ДоХтор
 * @E-mail  drzoom@mail.ru
 * Скрипт отправки письма с подменой адреса
 */

 (!isset($_SESSION)) ? session_start() : null;

 define('_IN_JOHNCMS', 1);
 $headmod = 'E-mail';
 $textl = 'Отправка E-mail';
 require_once '../incfiles/core.php';
 require_once '../incfiles/head.php';
 
 if ($user_id){
     if ($_POST){
         $to = isset($_POST['to']) ? htmlspecialchars(trim($_POST['to'])) : '';
         $thm = isset($_POST['thm']) ? htmlspecialchars(trim($_POST['thm'])) : '';
         $txt = isset($_POST['txt']) ? htmlspecialchars(trim($_POST['txt'])) : '';
         $txt = wordwrap($txt, 70);
         $from = isset($_POST['from']) ? htmlspecialchars(trim($_POST['from'])) : '';
         $headers = 'From: '. $from ."\r\n".
                    'MIME-Version: 1.0' ."\r\n".
                    'Content-type: text/html; charset=utf-8';
         
         $error = array(); //Массив с ошибками
         if (!$to){
             $error[] = '<b>Не введен e-mail!</b>';
         } elseif (preg_match('/[0-9a-z_\.\-]+@[0-9a-z_\.\-]+\.[a-z]{2,4}/i', $to) == false){
             $error[] = '<b>Не корректный ввод адреса e-mail!</b>';
         }
                  
         if (!$from){
             $error[] = '<b>Не введен e-mail отправителя!</b>';
         } elseif (preg_match('/[0-9a-z_\.\-]+@[0-9a-z_\.\-]+\.[a-z]{2,4}/i', $from) == false){
             $error[] = '<b>Не корректный ввод обратного адреса e-mail!</b>';
         }
         
         if (!$thm){
             $thm = 'Без темы.';
         }
         
         if (!$txt){
             $error[] = '<b>Не введен текст сообщения!</b>';
         }
         
         if (!$error){
             if (!isset($_SESSION['time']) || ($timeoff = time() - $_SESSION['time']) > 9){
                 unset($_SESSION['time']);
                 mail($to, $thm, $txt, $headers);
                 $view = '<audio autoplay>
                          <source src="music.ogg" type="audio/ogg; codecs=vorbis">
                          <source src="music.wav" type="audio/wav">
                          Тег "audio" не поддерживается вашим браузером.
                          <a href="music.wav">Скачать звук оповещения</a>.
                          </audio>';
                 $view .= '<b>Письмо отправлено!</b><br />'.
                         'Кому: <b>'. $to .'</b><br />'.
                         'От кого: <b>'. $from .'</b><br />'.
                         'Тема: <b>'. $thm .'</b><br />'.
                         'Текст: <b>'. $txt .'</b><br />';
                 $_SESSION['time'] = time();
             } else {
                 $view = 'Подождите '. ($timeoff - 10) .'- сек.';
             }
         } else {
             $view = implode('<br />', $error);
         }
     } ?>
     <div class="phdr">Отправка E-mail с подменой адреса</div>
     <div class="gmenu">
         <form action="my_mail.php" method="post">
             Кому: <br /><input name="to" value="<?=$to?>" /><br />
             От кого: <br /><input name="from" value="<?=$from?>" /><br />
             Тема: <br /><input name="thm" value="<?=$thm?>" /><br />
             Сообщение: <br /><textarea name="txt" cols="25" rows="4"></textarea><br />
             <input type="submit" value="Отправить"/>
         </form>
         <?=$view?>
     </div>
<?php
 } else {
     echo'<b>Вы не авторизованы!</b>';
 }
 require_once '../incfiles/end.php';