<?php
/*
 * Copyright (C) 2015 Jahak
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
require 'Logs.php';
date_default_timezone_set('Asia/Yekaterinburg');
?>
<!doctype html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>User Agent и IP пользователей</title>
    </head>
    <body>
        <table width="100%">
            <caption>User Agent и IP пользователей</caption>
            <tr>
                <th><a href="?<?= isset($_GET['sDate']) ? '' : 'sDate' ?>" title="Сортировка по дате">Дата</a></th>
                <th>User Agent</th>
                <th>IP</th>
            </tr>
            <?php
            $logs = new Logs();
            $read = $logs->read();
            // здесь происходит сортировка
            if ( isset($_GET['sDate']) )
            {
                asort($read);
            }
            else
            {
                arsort($read);
            }
            // начинаем выводить инфу
            foreach ( $read as $key => $timestamp )
            {
                // плюшка помогает увидеть свой арбуз и айпи в общей таблице
                if ( $logs->getUaIp() === $key )
                {
                    $style = 'background-color: #F7F8EB; color: #424E5A;';
                }
                else
                {
                    $style = 'background-color: #F0F6FB; color: #424E5A;';
                }
                printf('<tr><td style="%s">%s</td><td style="%s">%s</td></tr>', $style, date('Y-m-d H:i:s', $timestamp), $style, implode('</td><td style="' . $style . '">', explode($logs->glue, $key)));
            }
            unset($read, $timestamp, $key, $style);
            ?>
        </table>
        <?php
        echo $logs->info();
        unset($logs);
        ?>
    </body>
</html>