<?php
/**
 * Created by PhpStorm.
 * User: Venom
 * Date: 04.12.2015
 * Time: 15:15
 */

defined('_IN_JOHNCMS') or die('Restricted access');

/*
 * Дата окончания таймера
 * Примеры:
 * December 31 2015 00:00:59 UTC+0200
 * January 01 2016 00:00:00 UTC+0200
 */

$endtime = 'January 01 2016 00:00:00 UTC+0200';
//$endtime = 'December 01 2015 00:00:59 UTC+0200'; // TEST

?>
<style>
    /* Цвет фона контейнера и бордеры, писал под себя - смените :) */
    .content {
        background-color: #989595;
        border-top: 1px solid #636363;
        border-bottom: 1px solid #353535;
    }

    .content{padding:5px 0 5px;width:100%;height:100%}.new-year{position:relative;background:url('data:image/png;base64,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') no-repeat;margin:0;padding:0;height:126px;width:99px}.santa{display:block;position:absolute;top:32px;left:81px;background:transparent;width:100%;min-width:170px}.santa-reply:after{content:' ';position:absolute;z-index:3;width:0;height:0;left:-16px;top:5px;border:8px solid;border-color:#f0f5fa #f0f5fa transparent transparent}.santa-reply:before{content:' ';position:absolute;z-index:3;width:0;height:0;left:-22px;top:2px;border:10px solid;border-color:#BF2525 #BF2525 transparent transparent}.santa-reply{display:block;z-index:3;position:relative;top:0;left:0;background:#f0f5fa;border:3px solid #BF2525;-webkid-border-radius:10px 10px 10px 10px;-moz-border-radius:10px 10px 10px 10px;border-radius:10px;-moz-box-shadow:0.7em 0.7em 1em -0.5em rgba(0, 0, 6, 0.5);-webkid-box-shadow:0.7em 0.7em 1em -0.5em rgba(0, 0, 6, 0.5);box-shadow:0.7em 0.7em 1em -0.5em rgba(0, 0, 6, 0.5);font:normal normal 100% Comic Sans MS;color:#000;padding:5px;margin:0;width:100%}#clockdiv h3{margin:0;padding:0;font-size:13px;color:red;font-weight:normal}#clockdiv{font-family:sans-serif;color:#fff;display:inline-block;font-weight:100;text-align:center;font-size:20px}#clockdiv > div{padding:3px;border-radius:3px;background:#CA3B3B;display:inline-block;margin-top:4px}#clockdiv div > span{padding:3px 5px 1px 5px;border-radius:3px;background:#9A4141;display:inline-block}.smalltext{padding-top:5px;font-size:12px}#clockdiv h3.new-year-yes{font-size:19px;color:red;font-weight:600}
</style>
<div class="content">
    <div class="new-year">
        <div class="santa">
            <div class="santa-reply">
                <div id="clockdiv">
                    <h3>До Нового года осталось:</h3>
                    <div>
                        <span class="days"></span>
                        <div class="smalltext">Дн.</div>
                    </div>
                    <div>
                        <span class="hours"></span>
                        <div class="smalltext">Час.</div>
                    </div>
                    <div>
                        <span class="minutes"></span>
                        <div class="smalltext">Мин.</div>
                    </div>
                    <div>
                        <span class="seconds"></span>
                        <div class="smalltext">Сек.</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script Language="javascript">
    var getTime = function (endtime) {
        var t = Date.parse(endtime) - Date.parse(new Date());
        return {
            'total': t,
            'days': Math.floor(t / (1000 * 60 * 60 * 24)),
            'hours': Math.floor((t / (1000 * 60 * 60)) % 24),
            'minutes': Math.floor((t / 1000 / 60) % 60),
            'seconds': Math.floor((t / 1000) % 60)
        };
    };
    var initClock = function (id, endtime) {
        var clock = document.getElementById(id);
        var updateClock = function () {
            var t = getTime(endtime);
            clock.querySelector('.days').innerHTML = t.days;
            clock.querySelector('.hours').innerHTML = ('0' + t.hours).slice(-2);
            clock.querySelector('.minutes').innerHTML = ('0' + t.minutes).slice(-2);
            clock.querySelector('.seconds').innerHTML = ('0' + t.seconds).slice(-2);
            if (t.total <= 0) {
                clearInterval(timeinterval);
                clock.innerHTML = '<h3 class="new-year-yes">С Новым годом!!!</h3>';
            }
        };
        updateClock();
        var timeinterval = setInterval(updateClock, 1000);
    };
    var deadline = '<?php echo $endtime;?>';
    initClock('clockdiv', deadline);
    //console.log(new Date()); //test
</script>
