<?php

// Ссылка на RSS ленту
$uri = 'http://www.3dnews.ru/news/rss/';
//$uri = 'http://www.3dnews.ru/software-news/rss/';
//$uri = 'http://4pda.ru/feed/';
//$uri = 'http://www.championat.com/xml/rss.xml';

// Настройка вывода новостей
$numberOfNews = 20;        // К-во выводимых новостей

// Настройка кэширования новостей
$cacheFile = 'feed.cache'; // Файл кэша
$cacheTime = 30;           // Время кэширования в минутах

if (!is_file($cacheFile) || filemtime($cacheFile) < time() - $cacheTime * 60) {
    require 'zf.phar';

    try {
        // Пробуем считать новости из источника
        $rss = Zend\Feed\Reader\Reader::import($uri);

        // Формируем массив канала новостей
        $channel =
            [
                'title'       => $rss->getTitle(),
                'link'        => $rss->getLink(),
                'description' => $rss->getDescription(),
                'image'       => $rss->getImage(),
                'items'       => [],
            ];

        // Добавляем к массиву новости канала
        foreach ($rss as $item) {
            //$tmp = $item->indexEntries();
            $channel['items'][] =
                [
                    'title'       => $item->getTitle(),
                    'link'        => $item->getLink(),
                    'description' => $item->getDescription(),
                    'enclosure'   => $item->getEnclosure(),
                ];
        }

        // Записываем кэш
        file_put_contents($cacheFile, serialize($channel));
    } catch (\Exception $e) {
        echo 'Ошибка чтения из сайта источника <a href="' . $uri . '">' . $uri . '</a>';
        exit;
    }
} else {
    $channel = unserialize(file_get_contents($cacheFile));
}

echo '<table>'
    . '<tr>'
    . ($channel['image'] !== null ? '<td><img src="' . $channel['image']['uri'] . '"/></td>' : '')
    . '<td>'
    . '<span style="font-size: x-large; font-weight: bold;"><a href="' . $channel['link'] . '" target="_blanc">' . $channel['title'] . '</a></span><br/>'
    . '<small>' . $channel['description'] . '</small>'
    . '</td>';
echo '</tr></table>';

for ($i = 0; $i <= $numberOfNews; ++$i) {
    $item = $channel['items'][$i];
    echo $i % 2 ? '<div class="list2">' : '<div class="list1">';
    if($item['enclosure'] !== null && $item['enclosure']->type == 'image/jpeg'){
        echo '<img src="' . $item['enclosure']->url . '" style="max-width: 200px; float: left; margin-right: 10px"/>';
    }
    echo '<p><strong><a href="' . $item['link'] . '" target="_blanc">' . $item['title'] . '</a></strong><br>';
    echo $item['description'] . '</p>';
    echo '<div style="clear: both"></div>';
    echo '</div>';
}
