<?php

error_reporting(-1);

const _IN_JOHNCMS = 1;
$dir = explode(DIRECTORY_SEPARATOR, __DIR__);
$headmod = end($dir); # автоопределение папки
$textl = 'Банковский депозит';
require_once '../incfiles/core.php';
require_once '../incfiles/head.php';
functions::headmod(__FILE__, $headmod, $textl);
#-------------------------------------------#

// Вывод уведомлений о действиях на странице
if (!empty($_SESSION['ok'])) {
    echo $_SESSION['ok'];
    unset($_SESSION['ok']);
}

echo '<div class="phdr"><b>'. $textl .'</b></div>';

if ($user_id) {
    $minDeposit = 100;// Минимальный депозит
    $user = Bank::status($user_id);// Данные вкладчика
    $balans = Bank::balance($user_id);// Состояние баланса
    
    $user['bank_sts'] != 1 ?: $err[] = 'Ваша заявка на модерации!';
    
    if ($user['bank_sts'] != 2) {
        $balans >= $minDeposit ?: $err[] = 'Недостаточно средств! '.
            'Для совершения операции требуется не менее <b>$ '. $minDeposit .
            '</b><br />На вашем счету <b>$ '. $balans .'</b>';
    }
    
    if (!empty($err)) {
        echo functions::display_error($err, '<a href="'. $home .'">На главную</a>');
        require_once '../incfiles/end.php';
        exit;
    }
    // Если депозит открыт
    if ($user['bank_sts'] == 2) {
        // Ежедневное увеличение депозита
        if (Bank::percentIncrease($user_id)) {
            header('Location: '. $home .'/bank/index.php');
            exit;
        }
        
        // Отображение текста сообщения
        if (isset($_GET['mail']) && $_GET['mail'] == 'new') {
            Bank::notification(0, $user_id, 1);// Отметка уведомлений, как прочтённых
            $_SESSION['ok'] = '<div class="gmenu">'. Bank::comment($user_id) .'</div>';
            header('Location: '. $home .'/bank/index.php');
            exit;
        } ?>
        
        <div class="bmenu">
            <table align="center" style="width:100%;">
                <tr><th class="gmenu" colspan="2">Статистика вашего депозита</th></tr>
                <tr>
                    <th class="bmenu">Дата</th>
                    <td class="menu"> 
                        <?=functions::display_date($user['bank_time'])?>
                    </td>
                </tr>
                <tr><th class="bmenu">Баланс</th><td class="menu">$ <?=$balans?></td></tr>
                <tr><th class="bmenu">Вклад</th><td class="menu">$ <?=$user['bank_sum']?></td></tr>
                <tr><th class="bmenu">Процент</th><td class="menu">% <?=$user['bank_pct']?></td></tr>
        
                <?php
                
                $depTerm = date('t');
                $days = intval((time() - $user['bank_time']) / (3600 * 24));
                $depEnd = $depTerm - $days;
                // Автовывод средств, если истёк срок депозита
                if ($depEnd < 1) {
                    // Перевод вклада с процентами на балланс
                    if (!empty($user['bank_max']) && Bank::processing(0, 0, '', 0, $user_id, 0, 0, 3)) {
                        $_SESSION['ok'] = '<div class="gmenu"><b>Перевод успешно выполнен!</b></div>';
                    } else {
                        $_SESSION['ok'] = '<div class="alarm"><b>Произошла ошибка!</b></div>';
                    }

                    header('Location: '. $home .'/bank/index.php');
                    exit;
                } ?>
        
                <tr><th class="bmenu">К-во дней</th><td class="menu"><?=$depEnd?></td></tr>
                <tr><th class="bmenu">Доход ($)</th><td class="menu"><?=$user['bank_max']?></td></tr>
                <tr><th class="gmenu" colspan="2">&nbsp;</th></tr>
            </table>
        </div>
        
        <?php
        
    } else {
        // Выводим сообщение об отказе
        if (isset($_GET['mail']) && $_GET['mail'] == 'new') {
            Bank::notification(0, $user_id, 1);// Отметка уведомлений, как прочтённых
            $_SESSION['ok'] = '<div class="rmenu">'. Bank::comment($user_id) .'</div>';
            header('Location: '. $home .'/bank/index.php');
            exit;
        }
        // Обработка выбранной суммы
        if (isset($_GET['sum'])) {
            $deposit = abs(intval($_GET['sum']));
            $balans >= $deposit ?: $err[] = 'Недостаточно средств! '.
                'Для совершения операции требуется не менее <b>$ '. $deposit .
                '</b><br />На вашем счету <b>$ '. $balans .'</b>';
            if (!empty($err)) {
                echo functions::display_error($err, '<a href="index.php">Назад</a>');
                require_once '../incfiles/end.php';
                exit;
            }
            // Если нет ошибок, отправляем заявку:
            if (Bank::processing(1, $deposit, null, 1, $user_id)) {
                echo '<div class="gmenu">Ваша заявка на сумму <b>$ '. $deposit .
                    '</b> принята! Ожидайте подтверждения администрации!</div>';
            } else {
                echo 'Произошол сбой отправки!';
            }
        } elseif (empty($err)) {
            $view = '<div class="topmenu">Выбор депозита</div>';
            for ($i = $minDeposit, $j = 0; $j++, $i <= 1000000; $i *= 2) {
                $view .= ($j % 2 ? '<div class="list1">' : '<div class="list2">') .
                    $j .'. <a href="?sum='. $i .'">$ '. $i .'</a></div>';
            }
            echo $view .= '<div class="topmenu">&nbsp;</div>';
        }
    }
} else {
    $err[] = 'Чтобы открыть депозит, авторизуйтесь по ссылке ниже!';
    echo functions::display_error($err, '<a href="../login.php">Войти в банк</a>');
}

#-------------------------------------------#
require_once '../incfiles/end.php';
