<?php

class KfileStorage {
    
    private $dir;
    
    public function __construct($dir) {
        if (!is_dir($dir)) {
            throw new RuntimeException('Directory ' . realpath($dir) . ' not found');
        }
        
        $this->dir = $dir;
    }
    
    public function lastInsert($files = 1) {
        return array_slice($this->map(), 0, $files * 2);
    }
    
    public function add($file) {
        if (!is_array($file)) {
            $data = $file->getData();
            $md5 = $data['md5'];
            $dir = $this->createDir($md5);
            $item = $dir . DIRECTORY_SEPARATOR . $md5;
            rename($data['path'], $item);
            file_put_contents($item . '.json', $json = json_encode(array('size' => $data['size'], 'ext' => $data['ext'])));
        } else {
            array_map(array($this, 'add'), $file);
        }
    }
    
    public function map() {
        $files = array();
        foreach (new RecursiveIteratorIterator(new RecursiveDirectoryIterator($this->dir), RecursiveIteratorIterator::CHILD_FIRST) as $fullFileName => $SplFileObject) {
            if ($SplFileObject->isFile() && $SplFileObject->getExtension() != 'json') {
                $files[basename($fullFileName)] = array('file' => $SplFileObject->getRealPath(), 'time' => $SplFileObject->getMTime());
            }
            uasort($files, array($this, 'sortByTime'));
        }
        
        return $files;
    }
    
    private function sortByTime($a, $b) {
        if ($a['time'] == $b['time']) {
            return 0;
        }
        return ($a['time'] > $b['time']) ? -1 : 1;
    }
    
    public function createDir($md5) {
        $first = substr($md5, 0, 2);
        $second = substr($md5, 2, 2);
        $dir = $this->dir . DIRECTORY_SEPARATOR . $first . DIRECTORY_SEPARATOR . $second;
        Kupload::checkDir($dir);
        
        return $dir;
    }
}