<?php
abstract class Entity{
  /**
   * @param int $limit [optional] Максимальное число запрашиваемых объектов.
   * @param int $offset [optional] Пропускаемые объекты.
   * @param array $order [optional] Правила сортировки.
   *
   * @return Entity[]
   */
  public static function fetchAll($limit = 10, $offset = 0, array $order = []){
    $db = getDatabase();
    $sql = buildSelectSql(static::$table, ['*'], null, $order, $limit, $offset);
    $rows = mysqli_query($db, $sql);

    $articles = [];
    while($article = mysqli_fetch_object($rows, static::class)){
      $articles[] = $article;
    }

    return $articles;
  }

  /**
   * @param int $id Идентификатор целевой сущности.
   *
   * @return Entity Экземпляр вызываемого класса с данным идентификатором.
   */
  public static function find($id){
    $db = getDatabase();
    $rows = mysqli_query($db, 'SELECT * FROM `' . static::$table . '` WHERE id = ' . (int) $id);

    return mysqli_fetch_object($rows, static::class);
  }

  /**
   * Восстанавливает состояние объекта из данных массива.
   *
   * @param array $data Данные.
   */
  abstract public function restoreFromArray(array $data);

  /**
   * Сохраняет состояние вызываемого объекта в базе данных.
   */
  public function save(){
    $db = getDatabase();

    $vars = array_map(function($val) use($db){
      return mysqli_real_escape_string($db, $val);
    }, get_object_vars($this));

    if(is_null($this->id)){
      unset($vars['id']);
      $sql = 'INSERT INTO ' . static::$table . ' (' . implode(',', array_keys($vars)) . ') VALUES ("' . implode('","', $vars) . '")';
    }
    else{
      $sql = 'UPDATE ' . static::$table . ' SET ' . implode(',', array_map(function($field, $value){
        return $field . ' = "' . $value .  '"';
      }, array_keys($vars), $vars)) . ' WHERE id = ' . $this->id;
    }

    $result = mysqli_query($db, $sql);

    if(is_null($this->id)){
      $this->id = (int) mysqli_insert_id($db);
    }

    return $result;
  }

  /**
   * Удаляет вызываемый объект из базы даных.
   */
  public function delete(){
    if(is_null($this->id)){
      return false;
    }

    $db = getDatabase();
    return mysqli_query($db, 'DELETE FROM ' . static::$table . ' WHERE id = ' . $this->id);
  }
}
