<?php
require_once(__DIR__ . '/core.php');

/**
 * Рендеринг и вывод представления.
 *
 * @param string $name Имя представления относительно директории view без 
 * расширения файла (на пример: article/view).
 * @param array $viewModel Переменные, которые будут переданы в представление.
 * @param string $layout Имя базового слоя шаблона.
 */
function view($name, array $viewModel = [], $layout = 'base'){
  extract($viewModel);

  if(!is_null($layout)){
    include(getConfig()['template']['dir'] . '/layout/header.' . $layout . '.phtml');
  }
  include(getConfig()['template']['dir'] . '/' . $name . '.phtml');
  if(!is_null($layout)){
    include(getConfig()['template']['dir'] . '/layout/footer.' . $layout . '.phtml');
  }
}

/**
 * Рендеринг и возврат блока представления.
 *
 * @param string $name Имя представления относительно директории view без 
 * расширения файла (на пример: article/view).
 * @param array $viewModel Переменные, которые будут переданы в представление.
 * @param string $layout Имя базового слоя шаблона.
 *
 * @return string Полученный HTML.
 */
function viewBlock($name, array $viewModel = []){
  ob_start();
  view($name, $viewModel, null);
  return ob_get_clean();
}

// Helpers
/**
 * @return int Текущая страница.
 */
function getPage(){
  return isset($_GET['page'])? (int) $_GET['page'] : 1;
}

/**
 * @return int Предыдущая страница.
 */
function getPrevPage(){
  $page = getPage() - 1;
  if($page < 1){
    $page = 1;
  }

  return $page;
}

/**
 * @return int Следующая страница.
 */
function getNextPage(){
  return getPage() + 1;
}

/**
 * @param string $text Обрезаемый текст.
 * @param int $maxlength Максимальное число символов.
 *
 * @return string Обрезаный текст до указанной длины.
 */
function truncate($text, $maxlength){
  return substr($text, 0, $maxlength) . '...';
}
