var regApp = angular.module('regApp', []);
regApp.controller('regController', ['$scope', '$http', function ($scope, $http) {

    $scope.nick = '';
    $scope.password = '';
    $scope.sex = {id: '?', value: '?'};
    $scope.sex_vals = [];
    $scope.imname = '';
    $scope.about = '';
    $scope.captcha = '';
    $scope.disableSave = true;
    $scope.nick_error = false;
    $scope.nick_error_text = '';

    $scope.checkForm = function () {
        // Проверяем длинну полей
        if (($scope.nick.length < 2
            && $scope.nick.length > 20)
            || $scope.password.length < 3
            || $scope.sex.id == '?'
            || $scope.captcha.length < 4
        ) {
            $scope.disableSave = true;
        } else {
            $scope.disableSave = false;
        }
    };

    // Проверяем наличие ника
    $scope.checkNick = function () {
        $http({
            method: 'POST',
            url: '/registration/checker.php',
            headers: {
                'Content-Type': undefined
            },
            data: {nick: $scope.nick}
        }).then(function successCallback(response) {
            if(response.data.login !== undefined) {
                $scope.disableSave = true;
                $scope.nick_error = true;
                $scope.nick_error_text = response.data.login;
            } else {
                $scope.disableSave = false;
                $scope.nick_error = false;
                $scope.nick_error_text = '';
                $scope.checkForm();
            }
        }, function errorCallback(response) {

        });
    };
}]);