<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

defined('_IN_JOHNCMS') or die('Error: restricted access');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

/** @var Johncms\Api\BbcodeInterface $bbcode */
$bbcode = $container->get(Johncms\Api\BbcodeInterface::class);

/** @var Johncms\Counters $counters */
$counters = $container->get('counters');

$userConfig = $systemUser->getConfig();

$mp = new Johncms\NewsWidget();


if ($systemUser->isValid() && $userConfig->chatbox) {
echo '<div class="mainblok">';
echo '<script type="text/javascript" src="' . $config['homeurl'] . '/system/plugin/src/Js/Jquery.js"></script><script type="text/javascript" src="http://ajax.microsoft.com/ajax/jquery.validate/1.7/jquery.validate.min.js"></script>';
echo '<script type="text/javascript" src="' . $config['homeurl'] . '/system/plugin/src/Js/chat.js"></script>';
echo '<div class="phdr"><i class="icon-comment-alt"></i> ChatBox</div>';
echo '<div class="topmenu"><a href="' . $config['homeurl'] . '/guestbook/index.php">Guestbook</a></div>';

echo '<script language="JavaScript" type="text/javascript">
function tag(text1, text2) {
if ((document.selection)) {
document.form.msg.focus();
document.form.document.selection.createRange().text = text1+document.form.document.selection.createRange().text+text2;
} else if(document.forms[\'form\'].elements[\'msg\'].selectionStart!=undefined) {
var element = document.forms[\'form\'].elements[\'msg\'];
var str = element.value;
var start = element.selectionStart;
var length = element.selectionEnd - element.selectionStart;
element.value = str.substr(0, start) + text1 + str.substr(start, length) + text2 + str.substr(start + length);
} else {
document.form.msg.value += text1+text2;
}
}

function show_hide(elem) {
              obj = document.getElementById(elem);
              if( obj.style.display == "none" ) {
                obj.style.display = "block";
              } else {
                obj.style.display = "none";
              }
            }
</script>';
$refer = base64_encode($_SERVER['REQUEST_URI']);
$token = mt_rand(1000, 100000);
$_SESSION['token'] = $token;
echo '<div class="gmenu">';
echo $bbcode->buttons('form', 'msg');
echo '<form id="form" action="" method="POST">
<textarea cols="5" rows="5" placeholder="Post messages" placeholder="Chat comment" id="postText" name="msg" class="form-control"></textarea>
<button name="submit" type="submit" id="submit" class="aan-blue">Send</button>
<input type="hidden" name="token" value="' . $token . '"/>
</form></div>';
echo '<div id="alert"></div><div id="postText"></div><div id="idChat"></div>';

echo '<div class="topmenu"><br/></div>';
echo '</div>';
}





// Блок информации
echo '<div class="mainblok">';
echo '<div class="phdr"><b>' . _t('Information', 'system') . '</b></div>';
echo $mp->news;
echo '<div class="menu"><a href="news/">' . _t('News archive', 'system') . '</a> (' . $mp->newscount . ')</div>' .
    '<div class="menu"><a href="help/">' . _t('Information, FAQ', 'system') . '</a></div>';
echo '</div>';
////////////////////////////////////////////////////////////
// Блок общения                                           //
////////////////////////////////////////////////////////////
echo '<div class="mainblok">';
echo '<div class="phdr"><b>' . _t('Communication', 'system') . '</b></div>';

// Ссылка на гостевую
if ($config->mod_guest || $systemUser->rights >= 7) {
    echo '<div class="menu"><a href="guestbook/index.php">' . _t('Guestbook', 'system') . '</a> (' . $counters->guestbook() . ')</div>';
}

// Ссылка на Форум
if ($config->mod_forum || $systemUser->rights >= 7) {
    echo '<div class="menu"><a href="forum/">' . _t('Forum', 'system') . '</a> (' . $counters->forum() . ')</div>';
}
echo '</div>';
////////////////////////////////////////////////////////////
// Блок полезного                                         //
////////////////////////////////////////////////////////////
echo '<div class="mainblok">';
echo '<div class="phdr"><b>' . _t('Useful', 'system') . '</b></div>';
echo '<div class="menu"><a href="http://wap4dollar.com/refer.php?refer=79qvgpader">User Upload</a></div>';
// Ссылка на загрузки
if ($config->mod_down || $systemUser->rights >= 7) {
    echo '<div class="menu"><a href="downloads/">' . _t('Downloads', 'system') . '</a> (' . $counters->downloads() . ')</div>';
}

// Ссылка на библиотеку
if ($config->mod_lib || $systemUser->rights >= 7) {
    echo '<div class="menu"><a href="library/">' . _t('Library', 'system') . '</a> (' . $counters->library() . ')</div>';
}
if ($config['menu_enable'] == 1) {
echo '<div class="menu"><a href="system/menu.php">WapMaster</a></div>';
}
echo '<div class="menu"><a href="http://wap4dollar.com/refer.php?refer=79qvgpader">Http Injector</a></div>';
echo '</div>';
////////////////////////////////////////////////////////////
// Блок Сообщества                                        //
////////////////////////////////////////////////////////////
if ($systemUser->isValid() || $config->active) {
    echo '<div class="mainblok">';
    echo '<div class="phdr"><b>' . _t('Community', 'system') . '</b></div>' .
        '<div class="menu"><a href="http://wap4dollar.com/refer.php?refer=79qvgpader">Top User</a></div>' .
        '<div class="menu"><a href="users/index.php">' . _t('Users', 'system') . '</a> (' . $counters->users() . ')</div>' .
        '<div class="menu"><a href="album/index.php">' . _t('Photo Albums', 'system') . '</a> (' . $counters->album() . ')</div>';
echo '</div>';
}






if ($systemUser->isValid() && $userConfig->LastPost) {
echo '<script type="text/javascript">
ddaccordion.init({
	headerclass: "submenuheader",
	contentclass: "submenu",
	revealtype: "click",
	mouseoverdelay: 200,
	collapseprev: true,
	defaultexpanded: [],
	onemustopen: false,
	animatedefault: false,
	persiststate: true, 
	toggleclass: ["", ""],
	togglehtml: ["suffix", "", ""],
	animatespeed: "fast",
	oninit:function(headers, expandedindices){
	},
	onopenclose:function(header, index, state, isuseractivated){
	}
})
</script>';
 
echo '<div class="mainblok">';

echo '<a href="#" class="submenuheader"><div class="phdr"> <i class="icon-edit"></i> Last Post </div></a>';
echo '<div class="submenu">';
require('forum.php');
echo '</div>';
echo '</div>';
}






echo '<div class="phdr"><a href="http://gazenwagen.com">Gazenwagen</a></div>';

 


